import { computed, defineComponent } from 'vue';
import { ViewModel } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import '@ibiz-template/theme/style/components/layout/view-layout/view-layout.scss';

export const ViewLayout = defineComponent({
  name: 'ViewLayout',
  props: {
    modelData: {
      type: ViewModel,
      required: true,
    },
    viewMode: {
      type: String, // ViewMode 类型
      default: 'ROUTE',
    },
    // 视图是否完成加载
    isComplete: {
      type: Boolean,
      default: false,
    },
    isLoading: {
      type: Boolean,
      default: false,
    },
  },
  setup(props) {
    const ns = useNamespace('view-layout');

    // 是否显示头部
    const isShowHeader = computed(() => {
      return props.modelData.source.showCaptionBar || !!props.modelData.toolbar;
    });

    return { ns, isShowHeader };
  },
  render() {
    return !this.isComplete ? (
      <div class={[this.ns.b(), this.ns.m(this.viewMode.toLowerCase())]}>
        {this.isLoading ? <i-spin size='large' fix></i-spin> : null}
      </div>
    ) : (
      <div
        class={[
          this.ns.b(),
          this.ns.m(this.modelData.modelClass),
          this.ns.m(this.viewMode.toLowerCase()),
          this.ns.is('no-header', !this.isShowHeader),
          this.ns.is('loading', this.isLoading),
        ]}
      >
        {this.isLoading ? <i-spin size='large' fix></i-spin> : null}
        {this.isShowHeader ? (
          <div class={this.ns.b('header')}>
            <div class={this.ns.b('header-content')}>
              <div class={this.ns.be('header-content', 'left')}>
                {this.modelData.source.showCaptionBar ? (
                  <div class={this.ns.be('header-content', 'caption')}>
                    {this.$scopedSlots.caption && this.$scopedSlots.caption({})}
                  </div>
                ) : null}
              </div>
              <div class={this.ns.be('header-content', 'right')}>
                <div class={this.ns.e('quick-search')}>
                  {this.$scopedSlots.quickSearch &&
                    this.$scopedSlots.quickSearch({})}
                </div>
                <div class={this.ns.e('toolbar')}>
                  {this.$scopedSlots.toolbar && this.$scopedSlots.toolbar({})}
                </div>
              </div>
            </div>
            <div class={this.ns.b('header-exp')}></div>
          </div>
        ) : null}
        <div class={this.ns.b('top')}>
          <div class={this.ns.be('top', 'message')}></div>
          <div class={this.ns.be('top', 'search-form')}>
            {this.$scopedSlots.searchForm && this.$scopedSlots.searchForm({})}
          </div>
        </div>
        <div class={this.ns.b('content')}>
          <div class={this.ns.be('content', 'left')}></div>
          <div class={this.ns.be('content', 'body')}>
            {this.$scopedSlots.default && this.$scopedSlots.default({})}
          </div>
          <div class={this.ns.be('content', 'right')}></div>
        </div>
        <div class={this.ns.b('footer')}>
          {this.$scopedSlots.footer && this.$scopedSlots.footer({})}
        </div>
      </div>
    );
  },
});
