import { defineComponent, ref, Ref } from 'vue';
import { useNamespace } from '@ibiz-template/vue-util';
import '@ibiz-template/theme/style/components/common/wf-version-select/wf-version-select.scss';

export const WfVersionSelect = defineComponent({
  name: 'WfVersionSelect',
  props: {
    versions: {
      type: Array<IData>,
      required: true,
    },
  },
  setup(props, { emit }) {
    const ns = useNamespace('wf-version-select');

    const items: Ref<readonly IData[]> = ref([]);

    if (props.versions?.length > 0) {
      items.value = props.versions;
    }

    // 当前值
    const curValue: Ref<string | number> = ref('');

    const onOkButtonClick = () => {
      emit('closeSelect', { ok: true, data: curValue.value });
    };
    const onCancelButtonClick = () => {
      emit('closeSelect');
    };

    return { ns, curValue, items, onOkButtonClick, onCancelButtonClick };
  },
  render() {
    return (
      <div class={this.ns.b()}>
        <i-select
          v-model={this.curValue}
          allow-clear
          clearable
          class={this.ns.e('dropdown-list')}
          placeholder='请选择版本'
        >
          {this.items.map(item => {
            return <i-option value={item.value}>{item.text}</i-option>;
          })}
        </i-select>
        <div class={this.ns.b('buttons')}>
          <i-button
            on-click={() => {
              this.onOkButtonClick();
            }}
          >
            确定
          </i-button>
          <i-button
            on-click={() => {
              this.onCancelButtonClick();
            }}
          >
            取消
          </i-button>
        </div>
      </div>
    );
  },
});
