import { EntityProxyMiddleware } from '../../core';
import { MiddlewareConsumer, Module, NestModule } from '@nestjs/common';
import { PhoneController } from './phone.controller';

export class PhoneMiddleware extends EntityProxyMiddleware {
  protected serviceTag = 'phone';
}

@Module({
  controllers: [PhoneController]
})
export class PhoneModule implements NestModule {
  configure(consumer: MiddlewareConsumer) {
    consumer.apply(PhoneMiddleware).forRoutes('(.*)/importdata', '(.*)/importtemplate', '(.*)/exportdata/(.*)');
  }
}

