import { HttpError, RuntimeError } from '@ibiz-template/core';
import { DefectModelError, UnsupportedModelError } from '@ibiz-template/model';

/**
 * 事件处理工具
 *
 * @author lxm
 * @date 2022-09-21 18:09:31
 * @export
 * @class ErrorHandler
 */
export class ErrorHandler {
  /**
   * 处理异常
   *
   * @author lxm
   * @date 2022-09-21 18:09:00
   * @static
   * @param {Error} err
   */
  static handlerError(err: Error) {
    if (
      err instanceof DefectModelError ||
      err instanceof UnsupportedModelError
    ) {
      ibiz.message.error(err.message, 10, true);
    } else if (err instanceof HttpError) {
      ibiz.notification.error({
        title: `网络异常 ${err.status}`,
        desc: err.message,
        duration: 10,
      });
    } else if (err instanceof RuntimeError) {
      ibiz.message.error(err.message);
    } else {
      console.error(err);
    }
  }
}
