import { useNamespace } from '@ibiz-template/vue-util';
import { computed, defineComponent } from 'vue';
import '@/styles/components/widgets/form/form-item-container.scss';

export default defineComponent({
  props: {
    required: {
      type: Boolean,
      required: true,
    },
    error: {
      type: String,
    },
    label: {
      type: String,
    },
    labelPos: {
      type: String,
      required: true,
    },
    labelWidth: {
      type: Number,
      required: true,
    },
  },
  setup(props) {
    const ns = useNamespace('form-item-container');

    const cssVars = computed(() => {
      if (props.labelWidth !== 130) {
        return ns.cssVarBlock({ 'label-width': `${props.labelWidth}px` });
      }
      return {};
    });
    return { ns, cssVars };
  },
  render() {
    return (
      <div
        class={[
          this.ns.b(),
          this.ns.m(this.labelPos.toLowerCase()),
          this.ns.is('required', this.required),
          this.ns.is('error', !!this.error),
        ]}
        style={this.cssVars}
      >
        <div class={[this.ns.b('content')]}>
          {this.labelPos === 'LEFT' || this.labelPos === 'TOP' ? (
            <div class={[this.ns.e('label')]} title={this.label}>
              {this.label}
            </div>
          ) : null}
          <div class={[this.ns.e('editor')]}>{this.$slots.default}</div>

          {this.labelPos === 'RIGHT' || this.labelPos === 'BOTTOM' ? (
            <div class={[this.ns.e('label')]} title={this.label}>
              {this.label}
            </div>
          ) : null}
        </div>
        {this.error ? (
          <div class={[this.ns.b('error')]}>{this.error}</div>
        ) : null}
      </div>
    );
  },
});
