import { FormButtonController } from '@ibiz-template/controller';
import { FormButtonModel } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent } from 'vue';
import '@/styles/components/widgets/form/form-button.scss';

export const FormButton = defineComponent({
  name: 'FormButton',
  props: {
    modelData: {
      type: FormButtonModel,
      required: true,
    },
    controller: {
      type: FormButtonController,
      required: true,
    },
  },
  setup() {
    const ns = useNamespace('form-button');
    return { ns };
  },
  render() {
    if (!this.controller.visible) {
      return null;
    }
    return (
      <i-button class={this.ns.b()}>{this.modelData.source.caption}</i-button>
    );
  },
});
export default FormButton;
