import {
  GridEditItemController,
  GridFieldColumnController,
  GridRowController,
} from '@ibiz-template/controller';
import { computed, defineComponent } from 'vue';

export const GridColumn = defineComponent({
  name: 'GridColumn',
  props: {
    fieldColumn: {
      type: GridFieldColumnController,
      required: true,
    },
    editItem: {
      type: GridEditItemController,
    },
    row: {
      type: GridRowController,
      required: true,
    },
  },
  setup(props) {
    /** 先看列是否启用行编辑，然后是否有配置编辑项，最后才看rowController控的状态 */
    const showRowEdit = computed(() => {
      return (
        props.fieldColumn.enableRowEdit &&
        props.editItem &&
        props.row.showRowEdit
      );
    });
    return { showRowEdit };
  },
  render() {
    if (this.showRowEdit && this.editItem) {
      return (
        <grid-edit-item
          controller={this.editItem}
          row={this.row}
        ></grid-edit-item>
      );
    }
    return (
      <grid-field-column
        controller={this.fieldColumn}
        row={this.row}
      ></grid-field-column>
    );
  },
});
export default GridColumn;
