import { FormPageController } from '@ibiz-template/controller';
import { FormPageModel } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent, VNode } from 'vue';

export default defineComponent({
  props: {
    modelData: {
      type: FormPageModel,
      required: true,
    },
    controller: {
      type: FormPageController,
      required: true,
    },
    caption: {
      type: String,
      required: true,
    },
  },
  setup() {
    const ns = useNamespace('form-page-item');
    return { ns };
  },
  render() {
    const defaultSlots: VNode[] = this.$slots.default || [];
    defaultSlots.forEach(item => {
      const data = item.data;
      if (data) {
        data.class = { [this.ns.b('child')]: true };
      }
    });
    return (
      <app-row
        class={[this.ns.b(), this.ns.m(this.modelData.modelClass)]}
        layout={this.modelData.source.getPSLayout()}
      >
        {defaultSlots.map(slot => {
          const opts = slot.componentOptions!;
          // eslint-disable-next-line @typescript-eslint/no-explicit-any
          const props = (opts.propsData || {}) as Record<string, any>;
          return (
            <app-col
              layoutPos={props.modelData.source.getPSLayoutPos()}
              modelData={props.modelData}
            >
              {slot}
            </app-col>
          );
        })}
      </app-row>
    );
  },
});
