import { IPSSysImage } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent, onBeforeMount, PropType } from 'vue';
import '@/styles/components/common/app-icon/app-icon.scss';

export const AppIcon = defineComponent({
  name: 'AppIcon',
  props: {
    icon: {
      type: Object as PropType<IPSSysImage>,
    },
    size: {
      type: String as PropType<'small' | 'medium' | 'large'>,
    },
  },
  setup(props) {
    const ns = useNamespace('icon');
    const BaseUrl = `${ibiz.env.assetsUrl}/img/`;
    let rendertype: JSX.Element;
    const icon = props.icon;
    onBeforeMount(() => {
      if (icon) {
        if (icon.cssClass) {
          rendertype = (
            <ion-icon class={ns.b()} name={icon.cssClass}></ion-icon>
          );
        }
        if (icon.imagePath) {
          if (icon.imagePath.endsWith('svg')) {
            if (icon.imagePath.startsWith('http')) {
              rendertype = (
                <ion-icon class={ns.b()} src={icon.imagePath}></ion-icon>
              );
            } else {
              rendertype = (
                <ion-icon
                  src={BaseUrl + icon.imagePath}
                  class={ns.b()}
                ></ion-icon>
              );
            }
          } else if (icon.imagePath.startsWith('http')) {
            rendertype = <img class={ns.b()} src={icon.imagePath} />;
          } else {
            rendertype = <img class={ns.b()} src={BaseUrl + icon.imagePath} />;
          }
        }
      }
    });
    return () => rendertype;
  },
});
export default AppIcon;
