import { computed, defineComponent } from 'vue';
import '@/styles/components/common/app-grid-pagination/app-grid-pagination.scss';
import { useNamespace } from '@ibiz-template/vue-util';

export const AppGridPagination = defineComponent({
  name: 'AppGridPagination',
  props: {
    total: {
      type: Number,
      required: true,
    },
    curPage: {
      type: Number,
      required: true,
    },
    size: {
      type: Number,
      required: true,
    },
  },
  setup(props) {
    const ns = useNamespace('grid-page');

    const start = computed(() => {
      return (props.curPage - 1) * props.size + 1;
    });

    const end = computed(() => {
      return props.curPage * props.size;
    });

    return { ns, start, end };
  },
  methods: {
    onPageChange(page: number) {
      this.$emit('change', page);
    },
    onPageSizeChange(size: number) {
      this.$emit('page-size-change', size);
    },
    pageReset() {
      this.$emit('page-reset');
    },
  },
  render() {
    return (
      <div class={this.ns.b()}>
        <i-page
          transfer={true}
          total={this.total}
          show-sizer
          show-elevator
          current={this.curPage}
          page-size={this.size}
          page-size-opts={[10, 20, 30, 40, 50, 60, 70, 80, 90, 100]}
          show-total
          on-on-change={this.onPageChange}
          on-on-page-size-change={this.onPageSizeChange}
        >
          <span class={this.ns.b('btn')}>
            <i-button
              icon='md-refresh'
              title='刷新'
              on-click={this.pageReset}
            ></i-button>
          </span>
          <span>
            显示&nbsp;{this.start}&nbsp;-&nbsp;{this.end}&nbsp;条，共&nbsp;
            {this.total}
            &nbsp;条数据
          </span>
        </i-page>
      </div>
    );
  },
});
export default AppGridPagination;
