import { IModal } from '@ibiz-template/runtime';
import { usePickupTreeViewController } from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';

export const PickupTreeView = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams>, default: () => ({}) },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
    noLoadDefault: { type: Boolean, required: false },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;

    const c = usePickupTreeViewController(proxy, props.modelPath);

    return { c };
  },
  render(h) {
    let treeComponent = null;
    if (this.c.complete) {
      const { tree } = this.c.model;
      if (this.c.providers[tree.name]) {
        treeComponent = h(this.c.providers[tree.name].component, {
          props: {
            modelData: tree,
            context: this.c.context,
            params: this.c.params,
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit(tree.name),
          },
        });
      }
    }
    return <md-view-base controller={this.c}>{treeComponent}</md-view-base>;
  },
});
