import { ControlType } from '@ibiz-template/model';
import { ViewPanelProvider } from './view-panel-provider';
import { PickupViewPanelProvider } from './pickup-view-panel-provider';
import { AppMenuProvider } from './app-menu-provider';
import { DashboardProvider } from './dashboard-provider';
import { EditFormProvider } from './edit-form-provider';
import { GridProvider } from './grid-provider';
import { ListProvider } from './list-provider';
import { SearchFormProvider } from './search-form-provider';

/**
 * 预置默认的部件适配器
 *
 * @author lxm
 * @date 2022-10-25 18:10:07
 * @export
 * @returns {*}  {void}
 */
export function presetControlProvider(): void {
  const { control: controlRegister } = ibiz.register;
  if (!controlRegister) {
    return;
  }
  controlRegister.register(ControlType.FORM, new EditFormProvider());
  controlRegister.register(ControlType.SEARCHFORM, new SearchFormProvider());
  controlRegister.register(ControlType.GRID, new GridProvider());
  controlRegister.register(ControlType.APP_MENU, new AppMenuProvider());
  controlRegister.register(ControlType.DASHBOARD, new DashboardProvider());
  controlRegister.register(ControlType.LIST, new ListProvider());
  controlRegister.register(ControlType.VIEWPANEL, new ViewPanelProvider());
  controlRegister.register(
    ControlType.PICKUP_VIEW_PANEL,
    new PickupViewPanelProvider(),
  );
}

export {
  EditFormProvider,
  SearchFormProvider,
  GridProvider,
  AppMenuProvider,
  DashboardProvider,
  ListProvider,
};
