import { FormDRUIPartController, ViewNeuron } from '@ibiz-template/controller';
import { FormDRUIPartModel } from '@ibiz-template/model';
import { defineComponent, getCurrentInstance } from 'vue';
import { IModal, ViewMode } from '@ibiz-template/runtime';
import { useController, useNamespace } from '@ibiz-template/vue-util';
import '@ibiz-template/theme/style/components/widgets/form/form-druipart.scss';

export const FormDRUIPart = defineComponent({
  name: 'FormDRUIPart',
  props: {
    modelData: {
      type: FormDRUIPartModel,
      required: true,
    },
    controller: {
      type: FormDRUIPartController,
      required: true,
    },
  },
  setup(props) {
    const ns = useNamespace('form-druipart');
    const viewPath = props.modelData.embedView.source.modelPath;

    // 模态对象
    const modal: IModal = { mode: ViewMode.EMBED };

    // 绑定强制刷新
    const { proxy } = getCurrentInstance()!;
    useController(proxy, props.controller);

    const onNeuronInit = (n: ViewNeuron) => {
      props.controller.setViewNeuron(n);
    };

    return {
      ns,
      modal,
      viewPath,
      onNeuronInit,
    };
  },
  render(h) {
    if (!this.controller.visible || !this.controller.viewComponentKey) {
      return null;
    }
    return (
      <div
        v-show={this.controller.visible}
        layout-pos={this.modelData.source.getPSLayoutPos()}
        class={this.ns.b()}
      >
        {h('ViewShell', {
          attrs: {
            context: this.$props.controller.context,
            params: this.$props.controller.params,
            modal: this.modal,
            modelPath: this.viewPath,
            noLoadDefault: true,
          },
          key: this.controller.viewComponentKey,
          on: {
            neuronInit: this.onNeuronInit,
          },
        })}
        {/* {this.controller.showMask && (
          <div class={this.ns.e('mask')}>请先保存主数据</div>
        )} */}
      </div>
    );
  },
});
export default FormDRUIPart;
