import { DropDownListEditorController } from '@ibiz-template/controller';
import { watch, ref, Ref, defineComponent, PropType } from 'vue';
import { useNamespace } from '@ibiz-template/vue-util';
import '@/styles/components/editor/ibiz-dropdown-list/ibiz-dropdown-list.scss';

export const IBizDropDownList = defineComponent({
  name: 'IBizDropDownList',
  props: {
    value: {
      type: String,
    },
    controller: {
      type: DropDownListEditorController,
    },
    data: {
      type: Object as PropType<IData>,
    },
  },
  emits: {
    change: (_value: string | Array<string>) => true,
  },
  setup(props, { emit }) {
    const ns = useNamespace('dropdown-list');
    const c = props.controller;
    // 是否是树形
    const hasChildren = ref(false);

    // 当前值
    const curValue: Ref<Array<string> | string | undefined> = ref('');

    watch(
      () => props.value,
      (newVal, oldVal) => {
        if (newVal && newVal !== oldVal) {
          curValue.value = c!.multiple ? props.value?.split(',') : props.value!;
        }
      },
      { immediate: true },
    );

    // 代码表
    const items: Ref<readonly IData[]> = ref([]);

    c!.loadCodeList(props.data!).then(codeList => {
      items.value = codeList;
      for (let i = 0; i < codeList.length; i++) {
        const _item = codeList[i];
        if (_item.children) {
          hasChildren.value = true;
          break;
        }
      }
    });

    // 值变更
    const onChange = (select: string | Array<string>) => {
      const value =
        Object.prototype.toString.call(select) === '[object Array]'
          ? (select as Array<string>).join(',')
          : select;
      emit('change', value);
    };

    return { ns, c, curValue, onChange, items, hasChildren };
  },

  render() {
    return (
      <div class={this.ns.b()}>
        {this.hasChildren ? (
          <div class={this.ns.e('tree-select')}>
            <app-select-tree
              value={this.curValue}
              nodes-data={this.items}
              multiple={this.c!.multiple}
            ></app-select-tree>
          </div>
        ) : (
          <div class={this.ns.e('select')}>
            <i-select
              value={this.curValue}
              allow-clear
              class={this.ns.e('dropdown-list')}
              multiple={this.c!.multiple}
              placeholder={this.c!.placeHolder}
              on-on-change={this.onChange}
            >
              {this.items.map(item => {
                return <i-option value={item.value}>{item.text}</i-option>;
              })}
            </i-select>
          </div>
        )}
      </div>
    );
  },
});
export default IBizDropDownList;
