import { IPSFlexLayout, IPSLayout } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent, PropType } from 'vue';

export const AppRow = defineComponent({
  name: 'AppRow',
  props: {
    layout: Object as PropType<IPSLayout>,
  },
  setup() {
    const ns = useNamespace('row');
    return { ns };
  },
  render() {
    if (this.layout?.layout === 'FLEX') {
      const { dir, align, vAlign } = this.layout as IPSFlexLayout;
      return (
        <div
          class={[this.ns.b(), this.ns.m('flex')]}
          style={`display:flex;flex-direction: ${dir};justify-content: ${align};align-items: ${vAlign};`}
        >
          {this.$slots.default}
        </div>
      );
    }
    return (
      <row class={[this.ns.b(), this.ns.m('grid')]}>{this.$slots.default}</row>
    );
  },
});
