import {
  GridFieldColumnController,
  GridRowController,
} from '@ibiz-template/controller';
import { defineComponent } from 'vue';
import { useNamespace } from '@ibiz-template/vue-util';

export const GridFieldColumn = defineComponent({
  name: 'GridFieldColumn',
  props: {
    controller: {
      type: GridFieldColumnController,
      required: true,
    },
    row: {
      type: GridRowController,
      required: true,
    },
  },
  setup() {
    const ns = useNamespace('grid-column');
    return { ns };
  },
  render() {
    return (
      <span class={this.ns.b()}>
        {this.row.data[this.controller.model.codeName]}
      </span>
    );
  },
});
export default GridFieldColumn;
