import { MDViewController, ViewController } from '@ibiz-template/controller';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent, PropType } from 'vue';

export const ViewBase = defineComponent({
  props: {
    controller: {
      type: Object as PropType<ViewController>,
      required: true,
    },
  },
  setup() {
    const ns = useNamespace('view');
    return { ns };
  },
  render() {
    const c = this.controller;

    // 外面的插槽同样传给view-layout
    const inheritSlots: IData = {};
    Object.keys(this.$scopedSlots).forEach(key => {
      if (key === 'default') {
        inheritSlots[key] = (arg: IData) => [
          c.viewLoading.isLoading && <spin size='large' fix></spin>,
          this.$scopedSlots[key]!(arg),
        ];
      } else {
        inheritSlots[key] = (arg: IData) => this.$scopedSlots[key]!(arg);
      }
    });

    return (
      <view-layout
        class={[
          this.ns.b(),
          c.complete && this.ns.b(this.controller.model.typeClass),
        ]}
        isComplete={c.complete}
        modelData={c.model}
        viewMode={c.modal.mode}
        scopedSlots={{
          caption: () => {
            if (c.complete && c.model.source.getPSSysImage()) {
              return [
                <app-icon icon={c.model.source.getPSSysImage()}></app-icon>,
                c.caption,
              ];
            }
            return c.caption;
          },
          toolbar: () => {
            if (c.complete && c.model.toolbar) {
              return [
                <view-toolbar
                  modelData={c.model.toolbar}
                  on-neuronInit={c.nerve.onNeuronInit(
                    c.model.toolbar.source.name,
                  )}
                  viewMode={c.modal.mode}
                ></view-toolbar>,
              ];
            }
            return null;
          },
          quickSearch: () => {
            const _c = c as MDViewController;
            if (_c.complete && _c.model.source.enableQuickSearch) {
              return (
                <quick-search
                  value={_c.query}
                  viewMode={c.modal.mode}
                  placeholder={_c.model.placeholder}
                  on-update={(val: string) => {
                    _c.query = val;
                  }}
                  on-search={() => _c.onSearch()}
                ></quick-search>
              );
            }
          },
          ...inheritSlots,
        }}
      />
    );
  },
});
