import { IModal } from '@ibiz-template/runtime';
import { useGridViewController } from '@ibiz-template/vue-util';
import {
  defineComponent,
  getCurrentInstance,
  onActivated,
  PropType,
} from 'vue';

export const GridView = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams>, default: () => ({}) },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;

    const c = useGridViewController(proxy, props.modelPath);

    // 表格视图激活刷新
    onActivated(() => c.refresh());

    return { c };
  },
  render() {
    return (
      <md-view-base controller={this.c}>
        {this.c.complete && (
          <grid-control
            modelData={this.c.model.grid}
            context={this.c.context}
            params={this.c.params}
            on-neuronInit={this.c.nerve.onNeuronInit(
              this.c.model.grid.source.name,
            )}
            grid-row-active-mode={this.c.model.gridRowActiveMode}
          ></grid-control>
        )}
      </md-view-base>
    );
  },
});
