import { IModal } from '@ibiz-template/runtime';
import { useListViewController } from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';

export const ListView = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams>, default: () => ({}) },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
    noLoadDefault: { type: Boolean, required: false },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;

    const c = useListViewController(proxy, props.modelPath);

    return { c };
  },
  render(h) {
    let listComponent = null;
    if (this.c.complete) {
      const { list } = this.c.model;
      if (this.c.providers[list.name]) {
        listComponent = h(this.c.providers[list.name].component, {
          props: {
            modelData: list,
            context: this.c.context,
            params: this.c.params,
            mdCtrlActiveMode: this.c.model.mdCtrlActiveMode,
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit(list.name),
          },
        });
      }
    }
    return <md-view-base controller={this.c}>{listComponent}</md-view-base>;
  },
});
