import { Body, Controller, Delete, Get, Param, Post, Put, Req, Res } from '@nestjs/common';
import { FastifyRequest, FastifyReply } from 'fastify';
import { NetService, ControllerBase } from '@/core';
import { Environment } from '@/environment';

@Controller()
export class ReginfoController extends ControllerBase {
  protected readonly http: NetService = new NetService('reginfo');

  @Post('/reginfos')
  async create(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Body() body: any,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/reginfo/create`;
      this.callAPI(request, response, url, body);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.post(request, response, url, body);
    return this.parseResponse(request, response, res);
  }

  @Get('/reginfos/:reginfo')
  async get(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Param('reginfo') reginfo: string,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/reginfo/get/${encodeURIComponent(reginfo)}`;
      this.callAPI(request, response, url);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.get(request, response, url);
    return this.parseResponse(request, response, res);
  }

  @Delete('/reginfos/:reginfo')
  async remove(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Param('reginfo') reginfo: string,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/reginfo/remove/${encodeURIComponent(reginfo)}`;
      this.callAPI(request, response, url);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.delete(request, response, url);
    return this.parseResponse(request, response, res);
  }

  @Put('/reginfos/:reginfo')
  async update(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Param('reginfo') reginfo: string,
    @Body() body: any,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/reginfo/update/${encodeURIComponent(reginfo)}`;
      this.callAPI(request, response, url, body);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.put(request, response, url, body);
    return this.parseResponse(request, response, res);
  }

  @Post('/reginfos/checkkey')
  async checkKey(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Body() body: any,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/reginfo/checkkey`;
      this.callAPI(request, response, url, body);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.post(request, response, url, body);
    return this.parseResponse(request, response, res);
  }

  @Get('/reginfos/getdraft')
  async getDraft(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Body() body: any,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/reginfo/getdraft`;
      this.callAPI(request, response, url);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.get(request, response, url);
    return this.parseResponse(request, response, res);
  }

  @Post('/reginfos/fetchdefault')
  async fetchDefault(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Body() body: any,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/reginfo/fetchdefault`;
      this.callFetchAPI(request, response, url, body);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.post(request, response, url, body);
    return this.parseResponse(request, response, res);
  }

  @Delete('/reginfos/batch')
  async removeBatch(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Body() body: any
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      let keys = '';
      if (body && body instanceof Array) {
        keys = body.join(',');
      }
      const url = `/reginfo/remove/${keys}`;
      delete request.headers['content-length'];
      this.callAPI(request, response, url);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.delete(request, response, url, { data: body });
    return this.parseResponse(request, response, res);
  }

  @Post('/reginfos/batch')
  async saveBatch(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Body() body: any
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/reginfo/save`;
      this.callAPI(request, response, url, body);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.post(request, response, url, body);
    return this.parseResponse(request, response, res);
  }
}
