import { Body, Controller, Delete, Get, Param, Post, Put, Req, Res } from '@nestjs/common';
import { FastifyRequest, FastifyReply } from 'fastify';
import { NetService, ControllerBase } from '@/core';
import { Environment } from '@/environment';

@Controller()
export class PhoneController extends ControllerBase {
  protected readonly http: NetService = new NetService('phone');

  @Post('/phones')
  async create(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Body() body: any,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/phone/create`;
      this.callAPI(request, response, url, body);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.post(request, response, url, body);
    return this.parseResponse(request, response, res);
  }

  @Get('/phones/:phone')
  async get(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Param('phone') phone: string,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/phone/get/${encodeURIComponent(phone)}`;
      this.callAPI(request, response, url);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.get(request, response, url);
    return this.parseResponse(request, response, res);
  }

  @Delete('/phones/:phone')
  async remove(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Param('phone') phone: string,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/phone/remove/${encodeURIComponent(phone)}`;
      this.callAPI(request, response, url);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.delete(request, response, url);
    return this.parseResponse(request, response, res);
  }

  @Put('/phones/:phone')
  async update(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Param('phone') phone: string,
    @Body() body: any,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/phone/update/${encodeURIComponent(phone)}`;
      this.callAPI(request, response, url, body);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.put(request, response, url, body);
    return this.parseResponse(request, response, res);
  }

  @Post('/phones/checkkey')
  async checkKey(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Body() body: any,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/phone/checkkey`;
      this.callAPI(request, response, url, body);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.post(request, response, url, body);
    return this.parseResponse(request, response, res);
  }

  @Get('/phones/getdraft')
  async getDraft(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Body() body: any,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/phone/getdraft`;
      this.callAPI(request, response, url);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.get(request, response, url);
    return this.parseResponse(request, response, res);
  }

  @Post('/phones/fetchdefault')
  async fetchDefault(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Body() body: any,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/phone/fetchdefault`;
      this.callFetchAPI(request, response, url, body);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.post(request, response, url, body);
    return this.parseResponse(request, response, res);
  }

  @Delete('/phones/batch')
  async removeBatch(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Body() body: any
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      let keys = '';
      if (body && body instanceof Array) {
        keys = body.join(',');
      }
      const url = `/phone/remove/${keys}`;
      delete request.headers['content-length'];
      this.callAPI(request, response, url);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.delete(request, response, url, { data: body });
    return this.parseResponse(request, response, res);
  }

  @Post('/phones/batch')
  async saveBatch(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Body() body: any
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/phone/save`;
      this.callAPI(request, response, url, body);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.post(request, response, url, body);
    return this.parseResponse(request, response, res);
  }
}
