import { IModal, ViewMode } from '@ibiz-template/runtime';
import { useEditView3Controller, useNamespace } from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType, ref } from 'vue';
import '@ibiz-template/theme/style/components/views/edit-view3/edit-view3.scss';

export const EditView3 = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams> },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = useEditView3Controller(proxy, props.modelPath);
    const ns = useNamespace('view-deeditview3');
    const lazyList = ref(['mainForm']);
    const onTabClick = (name: string) => {
      if (!lazyList.value.includes(name)) {
        lazyList.value.push(name);
      }
    };
    return { c, ns, onTabClick, lazyList };
  },
  render(h) {
    return (
      <view-base controller={this.c}>
        {this.c.complete && (
          <i-tabs
            class={[this.ns.be('', 'tab')]}
            name={this.c.model.drTab.source.name}
            on-on-click={this.onTabClick}
          >
            <i-tab-pane
              class={this.ns.be('', 'tab-item')}
              tab={this.c.model.drTab.source.name}
              label={this.c.model.drTab.source.editItemCaption}
              name={'mainForm'}
            >
              <edit-form-control
                modelData={this.c.model.form}
                context={this.c.context}
                params={this.c.params}
                on-neuronInit={this.c.nerve.onNeuronInit(
                  this.c.model.form.source.name,
                )}
              ></edit-form-control>
            </i-tab-pane>
            {this.c.model.drTab.pages.map(page => {
              const drPage = this.c.drPages[page.source.name];
              if (!drPage) {
                return;
              }
              return (
                <i-tab-pane
                  class={this.ns.be('', 'tab-item')}
                  tab={this.c.model.drTab.source.name}
                  disabled={this.c.isNewData}
                  label={page.source.caption}
                  name={page.source.name}
                >
                  {!this.c.isNewData &&
                    this.lazyList.includes(page.source.name) &&
                    h('ViewShell', {
                      attrs: {
                        context: drPage.context,
                        params: drPage.params,
                        modal: { mode: ViewMode.EMBED },
                        modelPath: page.embedView.source.modelPath,
                        // 流程跟踪视图用
                        deName: this.c.model.appEntity.source.codeName,
                      },
                      on: {
                        neuronInit: this.c.nerve.onNeuronInit(page.source.name),
                      },
                      key: drPage.key,
                    })}
                </i-tab-pane>
              );
            })}
          </i-tabs>
        )}
      </view-base>
    );
  },
});
