var ne = Object.defineProperty;
var ae = (e, t, s) => t in e ? ne(e, t, { enumerable: !0, configurable: !0, writable: !0, value: s }) : e[t] = s;
var T = (e, t, s) => (ae(e, typeof t != "symbol" ? t + "" : t, s), s);
import { GridFieldColumnController as j, GridRowController as re, WFStepTraceViewController as le, UploadEditorController as q, WFDynaEditView3Controller as ce } from "@ibiz-template/controller";
import { defineComponent as E, computed as L, h as a, getCurrentInstance as O, ref as h, watch as x, toRefs as _ } from "vue";
import { useNamespace as S, useViewController as H, usePropsWatch as X, getUploadProps as de, getEditorEmits as J, getGridUploadProps as G, getGridEditorEmits as V, useClickOutside as ue, useEventListener as me, getInputProps as pe, getGridInputProps as he, useGridCellEditor as fe, useWFStepTraceViewController as be, useEditView3Controller as ve } from "@ibiz-template/vue-util";
import { colorBlend as ye, HttpError as K, isImage as we, uploadFile as ge, RuntimeError as Fe } from "@ibiz-template/core";
import { getCookie as Ce } from "qx-util";
import { debounce as Ee } from "lodash-es";
import { IndexViewModel as Se, ViewType as Ue } from "@ibiz-template/model";
import { ViewMode as Y, PluginStaticResource as xe } from "@ibiz-template/runtime";
const ke = E({
  name: "CodeListGridColumn",
  props: {
    controller: {
      type: j,
      required: !0
    },
    row: {
      type: re,
      required: !0
    }
  },
  setup(e) {
    const t = S("grid-field-column"), s = L(() => {
      var l;
      if (e.controller.model.source.cLConvertMode !== "FRONT")
        return [];
      const n = e.row.data[e.controller.model.codeName];
      return (l = e.controller.codeListItems) != null && l.length && n ? n.split(",").map((f) => {
        const y = e.controller.codeListItems.find((p) => p.value === f);
        if (y) {
          const p = y.color || "#515a6e";
          return {
            text: y.text,
            colorStyle: t.cssVarBlock({
              color: p,
              "border-color": p,
              "bg-color": ye(p, "#fff")
            })
          };
        }
      }).filter(Boolean) : [];
    }), o = (n) => {
      e.controller.isLinkColumn && e.controller.openLinkView(e.row, n);
    }, i = L(() => {
      let n = "";
      switch (e.controller.model.align) {
        case "LEFT":
          n = "flex-start";
          break;
        case "RIGHT":
          n = "flex-end";
          break;
        default:
          n = "center";
          break;
      }
      return t.cssVarBlock({
        "justify-content": n
      });
    });
    return {
      ns: t,
      alignStyle: i,
      selectedItems: s,
      onCellClick: o
    };
  },
  render() {
    const e = this.controller, t = this.row.data[e.model.codeName];
    return a("div", {
      class: [this.ns.b(), e.isLinkColumn && this.ns.m("link-column")],
      style: this.alignStyle,
      on: {
        click: this.onCellClick
      }
    }, [this.selectedItems.length > 0 ? this.selectedItems.map((s) => a("span", {
      class: this.ns.e("code-list-item"),
      style: s.colorStyle
    }, [s.text])) : a("span", {
      class: this.ns.e("text")
    }, [t])]);
  }
});
class Te extends le {
  constructor() {
    super(...arguments);
    /**
     * 流程图url
     *
     * @type {string}
     * @memberof PresetWFChartViewController
     */
    T(this, "imgSrc");
  }
  async getUIData() {
    const s = Object.assign(this.context.clone(), this.params), o = await this.entityService.wf.getWFProcessDiagram(s), i = new Blob([o.data]);
    this.imgSrc = URL.createObjectURL(i);
  }
}
const Pe = E({
  name: "PresetWFChartView",
  props: {
    context: Object,
    params: {
      type: Object
    },
    modelPath: {
      type: String,
      required: !0
    },
    modal: {
      type: Object
    },
    deName: {
      type: String,
      required: !0
    }
  },
  setup(e) {
    const t = S("preset-wf-chart-view"), {
      proxy: s
    } = O(), o = H(s, (i, n) => new Te(e.modelPath, i, n));
    return X(s, "deName", o.setDeName.bind(o)), {
      c: o,
      ns: t
    };
  },
  render() {
    return a("div", {
      class: this.ns.b()
    }, [a("img", {
      attrs: {
        src: this.c.imgSrc
      }
    })]);
  }
});
const Ie = E({
  name: "WFToolbar",
  props: {
    wfLinks: {
      type: Array,
      required: !0
    }
  },
  setup(e, {
    emit: t
  }) {
    return {
      ns: S("wf-toolbar"),
      handleClick: async (i, n) => {
        t("wf-link-click", i, n);
      }
    };
  },
  render() {
    const e = this.wfLinks || [];
    return a("div", {
      class: `${this.ns.b()}`
    }, [e.length > 0 && e.map((t) => {
      const s = t.sequenceFlowName == "驳回" || t.sequenceFlowName == "取消";
      return a("div", {
        key: t.sequenceFlowId,
        class: [this.ns.e("item"), s ? this.ns.em("item", "reject") : ""]
      }, [a("i-button", {
        attrs: {
          title: t.sequenceFlowName
        },
        on: {
          click: (o) => this.handleClick(t, o)
        }
      }, [t.sequenceFlowName || ""])]);
    })]);
  }
}), Le = typeof btoa == "function", R = typeof Buffer == "function";
typeof TextDecoder == "function" && new TextDecoder();
const W = typeof TextEncoder == "function" ? new TextEncoder() : void 0, De = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=", I = Array.prototype.slice.call(De);
((e) => {
  let t = {};
  return e.forEach((s, o) => t[s] = o), t;
})(I);
const k = String.fromCharCode.bind(String);
typeof Uint8Array.from == "function" && Uint8Array.from.bind(Uint8Array);
const Ne = (e) => e.replace(/=/g, "").replace(/[+\/]/g, (t) => t == "+" ? "-" : "_"), Ae = (e) => {
  let t, s, o, i, n = "";
  const l = e.length % 3;
  for (let d = 0; d < e.length; ) {
    if ((s = e.charCodeAt(d++)) > 255 || (o = e.charCodeAt(d++)) > 255 || (i = e.charCodeAt(d++)) > 255)
      throw new TypeError("invalid character found");
    t = s << 16 | o << 8 | i, n += I[t >> 18 & 63] + I[t >> 12 & 63] + I[t >> 6 & 63] + I[t & 63];
  }
  return l ? n.slice(0, l - 3) + "===".substring(l) : n;
}, Q = Le ? (e) => btoa(e) : R ? (e) => Buffer.from(e, "binary").toString("base64") : Ae, Me = R ? (e) => Buffer.from(e).toString("base64") : (e) => {
  let s = [];
  for (let o = 0, i = e.length; o < i; o += 4096)
    s.push(k.apply(null, e.subarray(o, o + 4096)));
  return Q(s.join(""));
}, Oe = (e) => {
  if (e.length < 2) {
    var t = e.charCodeAt(0);
    return t < 128 ? e : t < 2048 ? k(192 | t >>> 6) + k(128 | t & 63) : k(224 | t >>> 12 & 15) + k(128 | t >>> 6 & 63) + k(128 | t & 63);
  } else {
    var t = 65536 + (e.charCodeAt(0) - 55296) * 1024 + (e.charCodeAt(1) - 56320);
    return k(240 | t >>> 18 & 7) + k(128 | t >>> 12 & 63) + k(128 | t >>> 6 & 63) + k(128 | t & 63);
  }
}, Be = /[\uD800-\uDBFF][\uDC00-\uDFFFF]|[^\x00-\x7F]/g, _e = (e) => e.replace(Be, Oe), $ = R ? (e) => Buffer.from(e, "utf8").toString("base64") : W ? (e) => Me(W.encode(e)) : (e) => Q(_e(e)), Z = (e, t = !1) => t ? Ne($(e)) : $(e);
function Ge(e, t, s) {
  var P;
  const o = h([]), i = h({
    Authorization: `Bearer ${Ce("access_token")}`
  }), n = h(""), l = h(""), d = {
    count: 0,
    cacheFiles: []
    // iview上传过程中不能改default-file-list,所以需要缓存
  }, u = (P = s.editorParams) == null ? void 0 : P.blackList;
  let f = [];
  u && typeof u == "string" && (f = u.split(",")), x(
    () => e.value,
    (r) => {
      o.value = r ? JSON.parse(r) : [];
    },
    { immediate: !0 }
  ), x(
    () => e.data,
    (r) => {
      if (r) {
        const c = s.calcBaseUrl(r);
        n.value = c.uploadUrl, l.value = c.downloadUrl;
      }
    },
    { immediate: !0, deep: !0 }
  ), x(
    o,
    (r) => {
      r != null && r.length && l.value && r.forEach((c) => {
        c.url = c.url || l.value.replace("%fileId%", c.id);
      });
    },
    { immediate: !0 }
  ), x(
    l,
    (r) => {
      r && o.value.length && o.value.forEach((c) => {
        c.url = l.value.replace("%fileId%", c.id);
      });
    },
    { immediate: !0 }
  );
  const y = () => {
    const r = [...o.value, ...d.cacheFiles], c = r.length > 0 ? JSON.stringify(r.map((b) => ({ name: b.name, id: b.id }))) : null;
    d.cacheFiles = [], t(c);
  }, p = (r) => {
    const c = r.name.trim().toLowerCase();
    if (f.some((g) => c.endsWith(`.${g}`)))
      return ibiz.message.error(`不可上传 ${f.join("、")}类型的文件！`), !1;
    d.count += 1;
  }, F = (r) => {
    r && (d.cacheFiles.push({
      name: r.filename,
      id: r.fileid
    }), d.count -= 1, d.count === 0 && y());
  }, C = (r, c) => {
    throw d.count -= 1, new K({
      response: { data: c, status: r.status }
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
    });
  }, U = (r) => {
    if (e.disabled)
      return;
    const c = o.value.findIndex((b) => b.id === r.id);
    c !== -1 && o.value.splice(c, 1), y();
  }, v = (r) => {
    const c = r.url || l.value.replace("%fileId%", r.id);
    s.fileDownload({ url: c, name: r.name });
  }, m = h(!1), w = h(""), D = h("");
  return {
    uploadUrl: n,
    downloadUrl: l,
    headers: i,
    files: o,
    onDownload: v,
    onError: C,
    onRemove: U,
    onSuccess: F,
    beforeUpload: p,
    showModal: m,
    modalTitle: w,
    iframeUrl: D,
    onModalCancel: () => {
      m.value = !1, w.value = "", D.value = "";
    },
    previewFile: (r) => {
      m.value = !0, w.value = r.name;
      const c = window.Environment.previewFileUrl;
      if (c) {
        const b = encodeURIComponent(
          Z(
            `${window.location.origin}${r.url}?fullfilename=${r.name}`
          )
        );
        D.value = `${c}/onlinePreview?url=${b}`;
      }
    }
  };
}
const Ve = E({
  name: "SyFileUpload",
  props: de(),
  emits: J(),
  setup(e, {
    emit: t
  }) {
    const s = S("sy-file-upload"), o = e.controller, {
      uploadUrl: i,
      headers: n,
      files: l,
      onDownload: d,
      onError: u,
      onRemove: f,
      onSuccess: y,
      beforeUpload: p,
      showModal: F,
      modalTitle: C,
      iframeUrl: U,
      onModalCancel: v,
      previewFile: m
    } = Ge(e, (w) => {
      t("change", w);
    }, o);
    return {
      ns: s,
      c: o,
      uploadUrl: i,
      headers: n,
      files: l,
      onDownload: d,
      onError: u,
      onRemove: f,
      onSuccess: y,
      beforeUpload: p,
      showModal: F,
      modalTitle: C,
      iframeUrl: U,
      onModalCancel: v,
      previewFile: m
    };
  },
  render(e) {
    return e("div", {
      class: [this.ns.b(), this.disabled ? this.ns.m("disabled") : "", this.readonly ? this.ns.m("readonly") : ""]
    }, [e("IUpload", {
      ref: "fileUpload",
      props: {
        action: this.uploadUrl,
        headers: this.headers,
        disabled: this.disabled,
        "default-file-list": this.files,
        multiple: this.c.model.multiple,
        type: this.c.model.isDrag ? "drag" : "select",
        accept: this.c.model.accept,
        "before-upload": this.beforeUpload,
        "on-success": this.onSuccess,
        "on-error": this.onError,
        "on-remove": this.onRemove,
        "on-preview": this.onDownload,
        "show-upload-list": !1
      }
    }, [this.c.model.isDrag ? e("div", {
      class: this.ns.bm("box", "drag")
    }, [e("i-icon", {
      attrs: {
        type: "md-cloud-upload"
      }
    }), e("div", {
      class: this.ns.be("box", "title")
    }, [e("span", ["将文件拖到此处，或"]), e("span", ["点击上传"])])]) : e("i-button", {
      attrs: {
        icon: "ios-cloud-upload-outline"
      },
      class: this.ns.bm("box", "select")
    }, ["上传文件"])]), e("div", {
      class: this.ns.b("file-list")
    }, [this.files.map((t) => e("div", {
      class: this.ns.b("file-item"),
      key: t.id
    }, [e("div", {
      class: this.ns.b("file-item-right")
    }, [e("div", {
      class: this.ns.b("file-item-right-title"),
      on: {
        click: () => this.previewFile(t)
      }
    }, [t.name]), e("div", {
      class: this.ns.b("file-item-right-action")
    }, [e("i-icon", {
      attrs: {
        type: "md-download"
      },
      on: {
        click: () => this.onDownload(t)
      }
    }), e("i-icon", {
      attrs: {
        type: "md-eye"
      },
      on: {
        click: () => this.previewFile(t)
      }
    }), this.disabled || this.readonly ? null : e("i-icon", {
      attrs: {
        type: "md-close"
      },
      on: {
        click: () => this.onRemove(t)
      }
    })])])]))]), e("i-modal", {
      attrs: {
        value: this.showModal,
        title: this.modalTitle,
        "class-name": this.ns.b("modal"),
        width: "70%",
        transfer: !1,
        "footer-hide": !0
      },
      on: {
        "on-cancel": this.onModalCancel
      }
    }, [e("iframe", {
      class: this.ns.b("iframe"),
      attrs: {
        src: this.iframeUrl
      }
    })])]);
  }
});
function M(e, t) {
  if (e.url = t.replace("%fileId%", e.id), e.status || (e.status = "finished"), !e.fileName) {
    const s = e.name.lastIndexOf(".");
    e.fileName = e.name.substring(0, s), e.fileExt = e.name.substring(s), e.isImage = we(e.name);
  }
  return e;
}
function ee(e) {
  const t = h(""), s = h(""), o = h([]);
  return x(
    e.data,
    (i) => {
      if (i) {
        const n = e.controller.value.calcBaseUrl(i);
        t.value = n.uploadUrl, s.value = n.downloadUrl;
      }
    },
    { immediate: !0, deep: !0 }
  ), x(
    e.value,
    (i) => {
      o.value = i ? JSON.parse(i) : [], o.value.length && s.value && o.value.forEach((n) => {
        M(n, s.value);
      });
    },
    { immediate: !0 }
  ), x(
    s,
    (i) => {
      i && o.value.length && o.value.forEach((n) => {
        M(n, i);
      });
    },
    { immediate: !0 }
  ), {
    downloadUrl: s,
    uploadUrl: t,
    valueList: o
  };
}
function te(e) {
  var B, P;
  const t = h("undo"), s = h([]), { downloadUrl: o, value: i, uploadUrl: n, controller: l } = e, d = (P = (B = l == null ? void 0 : l.value) == null ? void 0 : B.editorParams) == null ? void 0 : P.blackList;
  let u = [];
  d && typeof d == "string" && (u = d.split(",")), x(
    i,
    (r) => {
      r.length > 0 && (s.value = [], r.forEach((c) => {
        s.value.push(M(c, o.value));
      }));
    },
    {
      immediate: !0,
      deep: !0
    }
  );
  const f = (r, c) => {
    const b = [];
    return c.forEach((g, N) => {
      const A = g.name.trim().toLowerCase();
      if (u.some((ie) => A.endsWith(`.${ie}`))) {
        b.push(N);
        return;
      }
      s.value.push({
        name: g.name,
        status: g.status,
        percentage: g.percentage,
        id: g.uid,
        url: ""
      });
    }), b.length === c.length ? (ibiz.message.error(`不可上传 ${u.join("、")}类型的文件！`), !1) : (b.length && (b.forEach((g) => {
      r.splice(g, 1), c.splice(g, 1);
    }), ibiz.message.error(`不可上传 ${u.join("、")}类型的文件！`)), !0);
  }, y = (r) => {
    r.forEach((c) => {
      s.value.find((b) => b.id === c.uid ? (b.percentage = c.percentage, !0) : !1);
    });
  }, p = (r, c) => {
    r.forEach((b) => {
      s.value.find((g) => g.id === b.uid ? (g.status = b.status, g.id = c.data.fileid, g.name = c.data.filename, M(g, o.value), !0) : !1);
    });
  }, F = (r, c) => {
    var g;
    r.forEach((N) => {
      s.value.find((A) => A.id === N.uid ? (A.status = N.status, !0) : !1);
    });
    const b = new K(c);
    ibiz.notification.error({
      title: (g = b.status) == null ? void 0 : g.toString(),
      desc: b.message,
      duration: 10
    });
  }, C = (r) => {
    s.value = s.value.filter((c) => c.status === "finished"), t.value = "done";
  }, U = () => {
    ge({
      multiple: e.multiple,
      accept: e.accept,
      uploadUrl: n.value,
      beforeUpload: f,
      progress: y,
      success: p,
      error: F,
      finish: C
    });
  }, v = h(!1), m = h(""), w = h("");
  return {
    selectFile: U,
    fileList: s,
    uploadState: t,
    showModal: v,
    modalTitle: m,
    iframeUrl: w,
    onModalCancel: () => {
      v.value = !1, m.value = "", w.value = "";
    },
    previewFile: (r) => {
      v.value = !0, m.value = r.name;
      const c = window.Environment.previewFileUrl;
      if (c) {
        const b = encodeURIComponent(
          Z(
            `${window.location.origin}${r.url}?fullfilename=${r.name}`
          )
        );
        w.value = `${c}/onlinePreview?url=${b}`;
      }
    }
  };
}
const Re = E({
  name: "SyGridFileUpload",
  props: G(),
  setup(e) {
    const t = S("sy-grid-file-upload"), {
      value: s,
      data: o,
      controller: i
    } = _(e), {
      downloadUrl: n,
      uploadUrl: l,
      valueList: d
    } = ee({
      value: s,
      data: o,
      controller: i
    }), {
      fileList: u,
      showModal: f,
      modalTitle: y,
      iframeUrl: p,
      previewFile: F,
      onModalCancel: C
    } = te({
      downloadUrl: n,
      uploadUrl: l,
      value: d
    });
    return {
      ns: t,
      fileList: u,
      showModal: f,
      modalTitle: y,
      iframeUrl: p,
      downloadFile: (v) => {
        e.controller.fileDownload(v);
      },
      previewFile: F,
      onModalCancel: C
    };
  },
  render() {
    return a("grid-editor", {
      attrs: {
        disabled: this.disabled,
        readonly: this.readonly
      },
      class: [this.ns.b(), this.disabled ? this.ns.m("disabled") : "", this.readonly ? this.ns.m("readonly") : ""]
    }, [a("div", {
      class: this.ns.b("file-list")
    }, [this.fileList.map((e) => a("div", {
      class: this.ns.b("file-item"),
      key: e.id
    }, [a("div", {
      class: this.ns.b("file-item-title"),
      on: {
        click: () => this.previewFile(e)
      }
    }, [e.name]), a("div", {
      class: this.ns.b("file-item-action")
    }, [a("i-icon", {
      attrs: {
        type: "md-download"
      },
      on: {
        click: () => this.downloadFile(e)
      }
    }), a("i-icon", {
      attrs: {
        type: "md-eye"
      },
      on: {
        click: () => this.previewFile(e)
      }
    })])]))]), a("i-modal", {
      attrs: {
        value: this.showModal,
        title: this.modalTitle,
        "class-name": this.ns.b("modal"),
        width: "70%",
        transfer: !1,
        "footer-hide": !0
      },
      on: {
        "on-cancel": this.onModalCancel
      }
    }, [a("iframe", {
      class: this.ns.b("iframe"),
      attrs: {
        src: this.iframeUrl
      }
    })])]);
  }
}), We = E({
  name: "SyGridFileUploadContainer",
  props: G(),
  emits: V(),
  render(e) {
    return this.disabled || this.readonly ? e("SyGridFileUpload", {
      props: {
        ...this.$props
      }
    }) : e("SyEditGridFileUpload", {
      props: {
        ...this.$props
      },
      on: {
        change: (t, s) => {
          this.$emit("change", t, s);
        },
        rowSave: () => {
          this.$emit("rowSave");
        }
      }
    });
  }
});
const $e = E({
  name: "SyEditGridFileUploadPopover",
  props: {
    uploadUrl: {
      type: String,
      required: !0
    },
    downloadUrl: {
      type: String,
      required: !0
    },
    value: {
      type: Array,
      required: !0
    },
    controller: {
      type: q,
      required: !0
    }
  },
  emits: {
    close: (e) => !0
  },
  setup(e, {
    emit: t
  }) {
    const s = S("sy-edit-grid-file-upload-popover"), {
      downloadUrl: o,
      value: i,
      uploadUrl: n,
      controller: l
    } = _(e), {
      fileList: d,
      uploadState: u,
      selectFile: f
    } = te({
      downloadUrl: o,
      value: i,
      uploadUrl: n,
      controller: l
    }), y = h(), p = h(!1), F = ue(y, async (v) => {
      t("close", {
        isModified: p.value,
        resultFiles: d.value
      });
    });
    return x(u, (v) => {
      v === "done" ? (p.value = !0, F.proceed()) : v === "loading" && F.pause();
    }), {
      ns: s,
      componentRef: y,
      fileList: d,
      deleteFile: (v) => {
        const m = d.value.findIndex((w) => w.id === v.id);
        d.value.splice(m, 1), p.value = !0;
      },
      selectFile: f,
      downloadFile: (v) => {
        e.controller.fileDownload(v);
      }
    };
  },
  render() {
    return a("div", {
      ref: "componentRef",
      style: "width:300px",
      class: this.ns.b()
    }, [a("div", {
      class: this.ns.b("file-list")
    }, [this.fileList.map((e) => a("div", {
      class: this.ns.b("file-item"),
      key: e.id
    }, [a("div", {
      class: this.ns.b("file-item-title"),
      on: {
        click: () => this.downloadFile(e)
      }
    }, [e.name]), a("div", {
      class: this.ns.b("file-item-action")
    }, [a("i-icon", {
      attrs: {
        type: "md-close"
      },
      on: {
        click: () => this.deleteFile(e)
      }
    })])]))]), a("div", {
      on: {
        click: () => this.selectFile()
      },
      class: this.ns.e("button")
    }, [a("i-icon", {
      attrs: {
        type: "md-add"
      }
    }), "添加文件"])]);
  }
});
const ze = E({
  name: "SyEditGridFileUpload",
  props: G(),
  emits: V(),
  setup(e, {
    emit: t
  }) {
    const s = S("sy-edit-grid-file-upload"), {
      value: o,
      data: i,
      controller: n
    } = _(e), {
      downloadUrl: l,
      uploadUrl: d,
      valueList: u
    } = ee({
      value: o,
      data: i,
      controller: n
    }), f = h(), y = async () => {
      if (!f.value)
        throw new Fe("容器元素不存在");
      const p = f.value.$el, F = p.offsetHeight, C = ibiz.overlay.createPopover((m) => m($e, {
        props: {
          value: u.value,
          uploadUrl: d.value,
          downloadUrl: l.value,
          controller: n.value
        },
        on: {
          close: (w) => {
            C.dismiss(w);
          }
        }
      }), void 0, {
        noArrow: !0,
        placement: "bottom-start",
        offsetOpts: {
          mainAxis: -F,
          crossAxis: 0
        }
      });
      await C.present(p);
      const {
        isModified: U,
        resultFiles: v
      } = await C.onWillDismiss();
      if (U) {
        const m = v.length > 0 ? JSON.stringify(v.map((w) => ({
          name: w.name,
          id: w.id
        }))) : null;
        t("change", m), t("rowSave");
      }
    };
    return me(f, "click", (p) => {
      e.disabled || y();
    }), {
      ns: s,
      valueList: u,
      componentRef: f
    };
  },
  render() {
    return a("grid-editor", {
      attrs: {
        disabled: this.disabled,
        readonly: this.readonly
      },
      ref: "componentRef",
      class: this.ns.b()
    }, [a("div", {
      class: this.ns.b("file-list")
    }, [this.valueList.map((e) => a("div", {
      class: this.ns.b("file-item"),
      key: e.id
    }, [a("div", {
      class: this.ns.b("file-item-title")
    }, [e.name])]))])]);
  }
});
E({
  name: "SyInput",
  props: pe(),
  emits: J(),
  setup(e, {
    emit: t
  }) {
    const s = S("input"), i = e.controller.model, n = h(), l = h(2);
    i.editorType === "TEXTAREA_10" && (l.value = 10);
    const d = L(() => {
      switch (i.editorType) {
        case "TEXTBOX":
          return "text";
        case "PASSWORD":
          return "password";
        case "TEXTAREA":
        case "TEXTAREA_10":
          return "textarea";
        default:
          return "string";
      }
    }), u = h("");
    x(() => e.value, (m, w) => {
      m !== w && (m ? u.value = m : u.value = "");
    }, {
      immediate: !0
    });
    let f = !1, y, p;
    const F = Ee((m) => {
      p !== m.target.value && t("change", m.target.value), p = void 0, f = !1, y && y();
    }, 300, {
      leading: !0
    }), C = (m) => {
      f = !0, F(m);
    }, U = (m) => {
      m && m.code === "Enter" && f && (y = () => {
        n.value.$el.dispatchEvent(m);
      });
    }, v = () => {
      p = n.value.currentValue, t("change", p);
    };
    return e.autoFocus && x(n, (m) => {
      m && m.$el.getElementsByTagName("input")[0].focus();
    }), {
      ns: s,
      rows: l,
      type: d,
      currentVal: u,
      handleChange: C,
      handleKeyUp: U,
      handleBlur: v,
      inputRef: n
    };
  },
  render() {
    return a("div", {
      class: [this.ns.b(), this.ns.b("sy-input"), this.ns.is("textarea", Object.is(this.type, "textarea")), this.disabled ? this.ns.m("disabled") : "", this.readonly ? this.ns.m("readonly") : ""]
    }, [this.readonly ? this.currentVal : a("i-input", {
      ref: "inputRef",
      attrs: {
        value: this.currentVal,
        placeholder: this.controller.placeHolder,
        type: this.type,
        rows: this.rows,
        disabled: this.disabled,
        autosize: Object.is(this.type, "textarea")
      },
      on: {
        "on-change": this.handleChange,
        "on-blur": this.handleBlur
      },
      nativeOn: {
        keyup: this.handleKeyUp
      },
      class: this.ns.b("input")
    }, [this.controller.model.unitName && a("i", {
      class: this.ns.e("unit"),
      slot: "suffix"
    }, [this.controller.model.unitName])])]);
  }
});
E({
  name: "SyGridInput",
  props: he(),
  emits: V(),
  setup(e, {
    emit: t
  }) {
    const s = S("grid-input"), {
      isInfoMode: o,
      autoFocus: i,
      componentRef: n,
      onOperateChange: l,
      onChange: d
    } = fe(e, {
      emit: t
    });
    return {
      ns: s,
      isInfoMode: o,
      autoFocus: i,
      componentRef: n,
      onOperateChange: l,
      onChange: d
    };
  },
  render(e) {
    return e("grid-editor", {
      attrs: {
        disabled: this.disabled,
        readonly: this.readonly
      },
      ref: "componentRef",
      class: `${this.ns.b()}`
    }, [e("SyInput", {
      props: {
        ...this.$props,
        readonly: this.isInfoMode,
        disabled: this.disabled,
        autoFocus: this.autoFocus
      },
      on: {
        change: this.onChange,
        operate: this.onOperateChange
      }
    })]);
  }
});
function z(e, t) {
  return a("div", {
    class: e.e("logo")
  }, [t.appIconPath ? a("img", {
    class: e.e("logo-img"),
    attrs: {
      src: t.appIconPath
    }
  }) : null, a("div", {
    class: e.e("logo-caption")
  }, [t.caption])]);
}
const je = E({
  name: "UserAppLayout",
  props: {
    model: {
      type: Se,
      required: !0
    },
    // 视图是否完成加载
    isComplete: {
      type: Boolean,
      default: !1
    },
    // 是否显示分页导航
    isShowTabPageExp: {
      type: Boolean,
      default: !1
    }
  },
  setup(e, {
    emit: t
  }) {
    const s = S("layout"), o = h(!1), i = () => {
      o.value = !o.value, t("onCollapseChange", o.value);
    }, n = L(() => e.model.source.blankMode === !0), l = L(() => !!(window.Environment.manualdownloadurl || ibiz.env.manualdownloadurl));
    return {
      ns: s,
      collapseChange: o,
      isBlank: n,
      collapseMenus: i,
      isShowDownload: l,
      downloadUserBook: () => {
        const u = window.Environment.manualdownloadurl || ibiz.env.manualdownloadurl;
        u ? window.open(u) : console.log("环境变量里没有manualdownloadurl");
      }
    };
  },
  render() {
    return this.isComplete ? a("i-layout", {
      class: [this.ns.b(), this.isBlank ? this.ns.m("blank") : "", this.ns.is("collapse", this.collapseChange), this.ns.is("tab", this.isShowTabPageExp), "user-layout"]
    }, [a("i-sider", {
      attrs: {
        "hide-trigger": !0,
        value: this.collapseChange
      },
      class: [this.ns.b("nav"), this.ns.is("collapse", this.collapseChange)]
    }, [z(this.ns, this.model), this.$slots.menu]), a("i-layout", {
      class: [this.ns.b("content")]
    }, [a("i-header", {
      class: this.ns.b("header")
    }, [a("div", {
      class: this.ns.be("header", "left")
    }, [z(this.ns, this.model), a("div", {
      class: this.ns.be("header", "collapse-icon")
    }, [this.collapseChange ? a("ion-icon", {
      attrs: {
        src: "./assets/img/menu-unfold.svg"
      },
      on: {
        click: () => this.collapseMenus()
      }
    }) : a("ion-icon", {
      attrs: {
        src: "./assets/img/menu-fold.svg"
      },
      on: {
        click: () => this.collapseMenus()
      }
    })]), this.model.source.mainMenuAlign === "TOP" ? a("i-menu", {
      class: this.ns.be("header", "menu"),
      attrs: {
        mode: "horizontal",
        "active-name": "1"
      }
    }) : null]), a("div", {
      class: this.ns.be("header", "right")
    }, [this.isShowDownload && a("div", {
      class: "user-download",
      on: {
        click: () => this.downloadUserBook()
      }
    }, ["用户手册下载"]), a("app-user")])]), a("i-content", {
      class: this.ns.be("content", "main")
    }, [this.$slots.tabPageExp, this.$slots.default])])]) : null;
  }
});
class qe {
  constructor() {
    T(this, "component", Pe);
  }
}
class He {
  constructor() {
    T(this, "component", ke);
  }
  async createController(t, s) {
    const o = new j(t, s);
    return await o.init(), o;
  }
}
class Xe {
  constructor() {
    T(this, "component", "IndexView");
  }
}
const se = E({
  name: "WFStepTraceGrid",
  props: {
    context: Object,
    params: {
      type: Object
    },
    modelPath: {
      type: String,
      required: !0
    },
    modal: {
      type: Object
    },
    deName: {
      type: String,
      required: !0
    }
  },
  setup(e) {
    const {
      proxy: t
    } = O(), s = be(t, e.modelPath);
    X(t, "deName", s.setDeName.bind(s));
    const o = S("wf-step-trace-grid"), i = h([]);
    s.nerve.self.evt.on("mounted", () => {
      var l;
      s.data && ((l = s.data.usertasks) == null || l.forEach((d) => {
        d.identitylinks.length > 0 || (d.comments.length > 0 && d.comments.forEach((u) => {
          i.value.push({
            nodeName: d.userTaskName,
            personName: u.authorName,
            time: u.time,
            content: u.type,
            comment: u.fullMessage
          });
        }), i.value.sort((u, f) => Date.parse(f.time) - Date.parse(u.time)));
      }));
    });
    const n = h([{
      title: "处理环节",
      key: "nodeName",
      width: 180,
      resizable: !0
    }, {
      title: "处理人",
      key: "personName",
      width: 180,
      resizable: !0
    }, {
      title: "处理时间",
      key: "time",
      width: 180,
      resizable: !0
    }, {
      title: "处理内容",
      key: "content",
      width: 180,
      resizable: !0
    }, {
      title: "处理意见",
      key: "comment"
    }]);
    return {
      c: s,
      ns: o,
      gridData: i,
      columns: n
    };
  },
  render() {
    return a("div", {
      class: this.ns.b()
    }, [a("div", {
      class: this.ns.e("title")
    }, ["审批信息"]), a("i-table", {
      attrs: {
        "disabled-hover": !0,
        columns: this.columns,
        data: this.gridData
      },
      class: this.ns.e("grid")
    })]);
  }
});
class Je extends ce {
  async calcWfToolbar() {
    await super.calcWfToolbar(), this.isEditable && this.wfLinks.unshift({
      sequenceFlowName: "保存",
      type: "FORM_SAVE"
    });
  }
  async onLinkClick(t) {
    t.type === "FORM_SAVE" ? await this.save() : super.onLinkClick(t);
  }
}
const Ke = E({
  props: {
    context: Object,
    params: {
      type: Object
    },
    modelPath: {
      type: String,
      required: !0
    },
    modal: {
      type: Object
    }
  },
  setup(e) {
    const {
      proxy: t
    } = O(), s = H(t, (l, d) => new Je(e.modelPath, l, d)), o = S(`view-${Ue.DE_WF_DYNA_EDIT_VIEW3}`.toLowerCase()), i = h(["mainForm"]);
    return {
      c: s,
      ns: o,
      onTabClick: (l) => {
        i.value.includes(l) || i.value.push(l);
      },
      lazyList: i
    };
  },
  render(e) {
    const t = [];
    if (this.c.complete) {
      const {
        activeForm: s
      } = this.c;
      s && this.c.providers[s.name] && t.push(e(this.c.providers[s.name].component, {
        props: {
          modelData: s,
          context: this.c.context,
          params: this.c.params
        },
        style: {
          height: "auto"
        },
        on: {
          neuronInit: this.c.nerve.onNeuronInit("form")
        }
      }));
    }
    if (this.c.complete && this.c.model.drTab.pages[0]) {
      const s = this.c.model.drTab.pages[0], o = this.c.drPages[s.source.name];
      t.push(e(se, {
        attrs: {
          context: o.context,
          params: o.params,
          deName: this.c.model.appEntity.source.codeName,
          modal: this.modal,
          modelPath: s.embedView.source.modelPath
        }
      }));
    }
    return e("view-base", {
      attrs: {
        controller: this.c
      },
      scopedSlots: {
        toolbar: () => this.c.complete ? [this.c.wfLinks.length > 0 && e("wf-toolbar", {
          attrs: {
            wfLinks: this.c.wfLinks
          },
          on: {
            "wf-link-click": (s) => {
              this.c.onLinkClick(s);
            }
          }
        })] : null
      }
    }, [this.c.complete && e("i-tabs", {
      class: [this.ns.be("", "tab")],
      attrs: {
        name: this.c.model.drTab.source.name
      },
      on: {
        "on-click": this.onTabClick
      }
    }, [e("i-tab-pane", {
      class: this.ns.be("", "tab-item"),
      attrs: {
        tab: this.c.model.drTab.source.name,
        label: this.c.model.drTab.source.editItemCaption,
        name: "mainForm"
      }
    }, [t]), this.c.model.drTab.pages.map((s) => {
      const o = this.c.drPages[s.source.name];
      return e("i-tab-pane", {
        class: this.ns.be("", "tab-item"),
        attrs: {
          tab: this.c.model.drTab.source.name,
          disabled: this.c.isNewData,
          label: s.source.caption,
          name: s.source.name
        }
      }, [!this.c.isNewData && this.lazyList.includes(s.source.name) && e("ViewShell", {
        attrs: {
          context: o.context,
          params: o.params,
          modal: {
            mode: Y.EMBED
          },
          modelPath: s.embedView.source.modelPath,
          // 流程跟踪视图用
          deName: this.c.model.appEntity.source.codeName
        },
        on: {
          neuronInit: this.c.nerve.onNeuronInit(s.source.name)
        },
        key: o.key
      })]);
    })])]);
  }
});
class Ye {
  constructor() {
    T(this, "component", Ke);
  }
}
const Qe = E({
  name: "SyEditView3",
  props: {
    context: Object,
    params: {
      type: Object
    },
    modelPath: {
      type: String,
      required: !0
    },
    modal: {
      type: Object
    }
  },
  setup(e) {
    const {
      proxy: t
    } = O(), s = ve(t, e.modelPath), o = S("view-deeditview3"), i = h(["mainForm"]);
    return {
      c: s,
      ns: o,
      onTabClick: (l) => {
        i.value.includes(l) || i.value.push(l);
      },
      lazyList: i
    };
  },
  render(e) {
    return e("view-base", {
      attrs: {
        controller: this.c
      }
    }, [this.c.complete && e("i-tabs", {
      class: [this.ns.be("", "tab")],
      attrs: {
        name: this.c.model.drTab.source.name
      },
      on: {
        "on-click": this.onTabClick
      }
    }, [e("i-tab-pane", {
      class: this.ns.be("", "tab-item"),
      attrs: {
        tab: this.c.model.drTab.source.name,
        label: this.c.model.drTab.source.editItemCaption,
        name: "mainForm"
      }
    }, [e("edit-form-control", {
      attrs: {
        modelData: this.c.model.form,
        context: this.c.context,
        params: this.c.params
      },
      style: {
        height: "auto"
      },
      on: {
        neuronInit: this.c.nerve.onNeuronInit(this.c.model.form.source.name)
      }
    }), e(se, {
      attrs: {
        context: this.c.drPages[this.c.model.drTab.pages[0].source.name].context,
        params: this.c.drPages[this.c.model.drTab.pages[0].source.name].params,
        deName: this.c.model.appEntity.source.codeName,
        modal: this.modal,
        modelPath: this.c.model.drTab.pages[0].embedView.source.modelPath
      }
    })]), this.c.model.drTab.pages.map((t) => {
      const s = this.c.drPages[t.source.name];
      if (s)
        return e("i-tab-pane", {
          class: this.ns.be("", "tab-item"),
          attrs: {
            tab: this.c.model.drTab.source.name,
            disabled: this.c.isNewData,
            label: t.source.caption,
            name: t.source.name
          }
        }, [!this.c.isNewData && this.lazyList.includes(t.source.name) && e("ViewShell", {
          attrs: {
            context: s.context,
            params: s.params,
            modal: {
              mode: Y.EMBED
            },
            modelPath: t.embedView.source.modelPath,
            // 流程跟踪视图用
            deName: this.c.model.appEntity.source.codeName
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit(t.source.name)
          },
          key: s.key
        })]);
    })])]);
  }
});
class Ze {
  constructor() {
    T(this, "component", Qe);
  }
}
class et {
  constructor() {
    T(this, "formEditor", "SyFileUpload");
    T(this, "gridEditor", "SyGridFileUploadContainer");
  }
  async createController(t, s) {
    const o = new q(t, s);
    return await o.init(), o;
  }
}
const tt = new xe(import.meta.url), mt = {
  mateUrl: import.meta.url,
  install(e) {
    tt.loadStyle(["/style.css"]), ibiz.config.enableDataInfoBar = !1, ibiz.config.gridEditShowMode = "all", e.component("WfToolbar", Ie), ibiz.register.view.register(
      "VIEW_CUSTOM_SyWebIndexView",
      new Xe()
    ), ibiz.register.view.register(
      "VIEW_CUSTOM_PresetWFChartView",
      new qe()
    ), ibiz.register.gridColumn.register(
      "GRID_COLRENDER_CodeListGridColumn",
      new He()
    ), ibiz.register.view.register(
      "VIEW_CUSTOM_SyWfDynaEditView3",
      new Ye()
    ), ibiz.register.view.register(
      "VIEW_CUSTOM_SyEditView3",
      new Ze()
    ), e.component("SyFileUpload", Ve), e.component("SyGridFileUpload", Re), e.component("SyEditGridFileUpload", ze), e.component("SyGridFileUploadContainer", We), ibiz.register.editor.register(
      "EDITOR_CUSTOMSTYLE_SyFileUpload",
      new et()
    ), e.component("AppLayout", je);
  }
};
export {
  mt as default
};
