import xss from 'xss';

/**
 * @description 使用xss过滤
 * @export
 * @param {(string | number)} value
 * @returns {*}  {string}
 */
export function safeXss(value: string | number): string | number {
  // 数值不做处理
  if (typeof value === 'number') {
    return value;
  }
  if (!ibiz.config.enableXSS) {
    return value;
  }
  const result = xss(value as string);
  if (result !== value) {
    ibiz.message.warning('输入值存在不规范格式，已自动调整！');
  }
  return result;
}
