import { Prop, Component } from 'vue-property-decorator';
import { IPSAppDEListExplorerView } from "@ibiz/dynamic-model-api";
import { ModelTool } from "ibiz-core";
import { AppDefaultViewLayout } from "../app-default-view-layout/app-default-view-layout";
import './app-default-listexpview-layout.less';
@Component({})
export class AppDefaultListExpViewLayout extends AppDefaultViewLayout {

	/**
	 * 列表导航视图模型对象
	 *
	 * @type {IPSAppDEListExplorerView}
	 * @memberof AppDefaultListExpViewLayout
	 */
	@Prop() public declare viewInstance: IPSAppDEListExplorerView;

	/**
	 * 引擎初始化
	 *
	 * @param {*} [opts={}]
	 * @memberof AppDefaultListExpViewLayout
	 */
	public engineInit(opts: any = {}) {
		const controls: any[] = this.containerModel.getPSControls() || [];
		const listExpBar = ModelTool.findPSControlByType('LISTEXPBAR', controls);
		if (listExpBar) {
			let engineOpts = Object.assign({
				view: this,
				p2k: '0',
				isLoadDefault: this.viewInstance?.loadDefault,
				keyPSDEField: this.appDeCodeName.toLowerCase(),
				majorPSDEField: this.appDeMajorFieldName.toLowerCase(),
				listexpbar: (this.$refs[listExpBar.name] as any).ctrl,
			}, opts);
			this.engine.init(engineOpts);
		}
	}

	/**
	 * 计算目标部件数据
	 *
	 * @param {*} controlInstance
	 * @return {*} 
	 * @memberof AppDefaultListExpViewLayout
	 */
	public computeTargetCtrlData(controlInstance: any, args?: any) {
		const { targetCtrlName, targetCtrlParam, targetCtrlEvent } = super.computeTargetCtrlData(controlInstance, args);
		//	视图级参数
		Object.assign(targetCtrlParam.staticProps, { viewState: this.viewState, viewtag: this.viewtag, viewIsProxyMode: this.viewProxyMode });
		Object.assign(targetCtrlEvent, {
			closeView: ($event: any) => {
				this.$emit('view-event', { viewName: this.viewInstance.codeName, action: 'viewClosed', data: $event });
			}
		});
		return { targetCtrlName, targetCtrlParam, targetCtrlEvent };
	}
}