import { ListModel } from '@ibiz-template/model';
import { useListController, useNamespace } from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';

export const ListControl = defineComponent({
  name: 'ListControl',
  props: {
    modelData: {
      type: ListModel,
      required: true,
    },
    context: { type: Object as PropType<IContext>, required: true },
    params: { type: Object as PropType<IParams>, default: () => ({}) },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const ns = useNamespace('list');
    const c = useListController(
      proxy,
      props.modelData,
      props.context,
      props.params,
    );
    return { c, ns };
  },
  render() {
    if (!this.c.complete) {
      return;
    }
    return (
      <control-layout modelData={this.c.model}>
        {this.c.items.map(item => {
          return <div>{`${item.srfmajortext}:${item.srfkey}`}</div>;
        })}
      </control-layout>
    );
  },
});
