import { Body, Controller, Delete, Get, Param, Post, Put, Req, Res } from '@nestjs/common';
import { FastifyRequest, FastifyReply } from 'fastify';
import { NetService, ControllerBase } from '@/core';
import { Environment } from '@/environment';

@Controller()
export class RawMaterialController extends ControllerBase {
  protected readonly http: NetService = new NetService('rawmaterial');

  @Post('/rawmaterials')
  async create(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Body() body: any,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/rawmaterial/create`;
      this.callAPI(request, response, url, body);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.post(request, response, url, body);
    return this.parseResponse(request, response, res);
  }

  @Get('/rawmaterials/:rawmaterial')
  async get(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Param('rawmaterial') rawmaterial: string,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/rawmaterial/get/${encodeURIComponent(rawmaterial)}`;
      this.callAPI(request, response, url);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.get(request, response, url);
    return this.parseResponse(request, response, res);
  }

  @Delete('/rawmaterials/:rawmaterial')
  async remove(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Param('rawmaterial') rawmaterial: string,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/rawmaterial/remove/${encodeURIComponent(rawmaterial)}`;
      this.callAPI(request, response, url);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.delete(request, response, url);
    return this.parseResponse(request, response, res);
  }

  @Put('/rawmaterials/:rawmaterial')
  async update(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Param('rawmaterial') rawmaterial: string,
    @Body() body: any,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/rawmaterial/update/${encodeURIComponent(rawmaterial)}`;
      this.callAPI(request, response, url, body);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.put(request, response, url, body);
    return this.parseResponse(request, response, res);
  }

  @Post('/rawmaterials/checkkey')
  async checkKey(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Body() body: any,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/rawmaterial/checkkey`;
      this.callAPI(request, response, url, body);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.post(request, response, url, body);
    return this.parseResponse(request, response, res);
  }

  @Get('/rawmaterials/getdraft')
  async getDraft(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Body() body: any,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/rawmaterial/getdraft`;
      this.callAPI(request, response, url);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.get(request, response, url);
    return this.parseResponse(request, response, res);
  }

  @Post('/rawmaterials/fetchdefault')
  async fetchDefault(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Body() body: any,
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/rawmaterial/fetchdefault`;
      this.callFetchAPI(request, response, url, body);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.post(request, response, url, body);
    return this.parseResponse(request, response, res);
  }

  @Delete('/rawmaterials/batch')
  async removeBatch(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Body() body: any
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      let keys = '';
      if (body && body instanceof Array) {
        keys = body.join(',');
      }
      const url = `/rawmaterial/remove/${keys}`;
      delete request.headers['content-length'];
      this.callAPI(request, response, url);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.delete(request, response, url, { data: body });
    return this.parseResponse(request, response, res);
  }

  @Post('/rawmaterials/batch')
  async saveBatch(
    @Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Body() body: any
  ): Promise<any> {
    if (Environment.EnableRuntime) {
      const url = `/rawmaterial/save`;
      this.callAPI(request, response, url, body);
      return;
    }
    const url = this.parseUrl(request.url);
    const res = await this.http.post(request, response, url, body);
    return this.parseResponse(request, response, res);
  }
}
