import { Controller, Get, Param, Req, Res } from '@nestjs/common';
import { FastifyRequest, FastifyReply } from 'fastify';
import { NetService } from '../../service';
import { ControllerBase } from '../../controller';

/**
 * 代码表
 *
 * @author chitanda
 * @date 2021-12-31 11:12:43
 * @export
 * @class CodeListController
 * @extends {ControllerBase}
 */
@Controller()
export class CodeListController extends ControllerBase {
  protected http: NetService = new NetService('dict');

  /**
   * 获取代码表
   *
   * @author chitanda
   * @date 2021-10-12 13:10:14
   * @param {FastifyRequest} req
   * @param {FastifyReply} res
   * @param {string} codeName
   * @return {*} 
   */
  @Get('/dictionaries/codelist/:codename')
  async getCodeList(@Req() request: FastifyRequest,
    @Res() response: FastifyReply,
    @Param('codename') codeName: string) {
    const url = `/dictionaries/codelist/${encodeURIComponent(codeName)}`;
    const res = await this.http.post(request, response, url);
    return this.parseResponse(request, response, res);
  }
}
