import { Component, Prop } from 'vue-property-decorator';
import { IPSAppDEEditView } from "@ibiz/dynamic-model-api";
import { AppServiceBase, ModelTool } from "ibiz-core";
import { AppDefaultViewLayout } from "../app-default-view-layout/app-default-view-layout";
import './app-default-editview-layout.less';
import { AppVisualSheet } from 'app-visual-sheet';

@Component({})
export class AppDefaultEditViewLayout extends AppDefaultViewLayout {

    /**
     * 编辑视图模型数据
     *
     * @type {IPSAppDEEditView}
     */
    @Prop() public declare viewInstance: IPSAppDEEditView;

    /**
     * 引擎初始化
     *
     * @param {*} [opts={}]
     * @memberof AppDefaultEditViewLayout
     */
    public engineInit(opts: any = {}) {
        const form = ModelTool.findPSControlByType('FORM', this.containerModel.getPSControls());
        if (form) {
            this.engine.init({
                view: this,
                form: (this.$refs[form.name] as any).ctrl,
                p2k: '0',
                isLoadDefault: this.viewInstance.loadDefault,
                keyPSDEField: this.appDeCodeName.toLowerCase(),
                majorPSDEField: this.appDeMajorFieldName.toLowerCase()
            });
        }
    }

    /**
     * 绘制头部内容
     * 
     * @memberof AppDefaultEditViewLayout
     */
    public renderViewHeader(): any {
        if (this.$slots.datapanel) {
            return [
                this.viewIsshowToolbar ? [<div class="toptoolbar">{this.$slots.toolbar}</div>, <divider class="toptoolbar-divider" />] : null,
                <div class='header-info-container'>
                    {
                        this.showCaption ? <span class='caption-info'>{this.$slots.captionInfo ? this.$slots.captionInfo : this.model.srfCaption}</span> : null
                    }
                    <div class='dataInfo-container'>{this.$slots.datapanel}</div>
                </div>,
            ]
        } else {
            return [
                this.showCaption ? <span class='caption-info'>{this.$slots.captionInfo ? this.$slots.captionInfo : this.model.srfCaption}</span> : null,
                this.viewIsshowToolbar ? this.$slots.toolbar : null,
            ]
        }
    }

    /**
     * 绘制主体内容
     *
     * @return {*} 
     * @memberof AppDefaultEditViewLayout
     */
     public renderMainContent() {
        const isRenderVisualCtrl = false;
        if(isRenderVisualCtrl){
            const appService = AppServiceBase.getInstance();
            const store = appService.getAppStore();
            const i18n = appService.getI18n();
            const router = appService.getRouter();
            return this.$createElement(AppVisualSheet as any, {
                props: { viewInstance: this.viewInstance, store: store, i18n: i18n, router: router }
            }, [
                this.$slots.default
            ])
        }else{
            return this.$slots.default;
        }
    }

    /**
     * 绘制内容
     * 
     * @memberof AppDefaultEditViewLayout
     */
    public renderContent() {
        let cardClass = {
            'view-card': true,
            'view-card2': this.$slots.datapanel ? true : false,
            'view-no-caption': !this.showCaption,
            'view-no-toolbar': !this.viewIsshowToolbar,
        };
        return (
            <card class={cardClass} disHover={true} bordered={false}>
                {(this.showCaption || this.viewIsshowToolbar) && (
                    <div slot='title' class='header-container' key='view-header'>
                        {this.renderViewHeader()}
                    </div>
                )}
                {this.$slots.topMessage}
                {this.$slots.searchForm}
                <div class='content-container'>
                    {this.$slots.bodyMessage}
                    {this.renderMainContent()}
                </div>
                {this.$slots.bottomMessage}
            </card>
        );
    }
}