import { IModal, ViewMode } from '@ibiz-template/runtime';
import {
  useWFDynaEditView3Controller,
  useNamespace,
} from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType, ref } from 'vue';
import { ViewType } from '@ibiz-template/model';
import { WFLink } from '@ibiz-template/controller';
import '@ibiz-template/theme/style/components/views/wf-dyna-edit-view3/wf-dyna-edit-view3.scss';

export const WFDynaEditView3 = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams> },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
    noLoadDefault: { type: Boolean, required: false },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = useWFDynaEditView3Controller(proxy, props.modelPath);
    const ns = useNamespace(
      `view-${ViewType.DE_WF_DYNA_EDIT_VIEW3}`.toLowerCase(),
    );
    const lazyList = ref(['mainForm']);
    const onTabClick = (name: string) => {
      if (!lazyList.value.includes(name)) {
        lazyList.value.push(name);
      }
    };

    return { c, ns, onTabClick, lazyList };
  },
  render(h) {
    let formComponent = null;
    if (this.c.complete) {
      const { activeForm } = this.c;
      if (activeForm && this.c.providers[activeForm.name]) {
        formComponent = h(this.c.providers[activeForm.name].component, {
          props: {
            modelData: activeForm,
            context: this.c.context,
            params: this.c.params,
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit('form'),
          },
        });
      }
    }
    return (
      <view-base
        controller={this.c}
        scopedSlots={{
          toolbar: () => {
            if (this.c.complete) {
              return [
                this.c.wfLinks.length > 0 && (
                  <wf-toolbar
                    wfLinks={this.c.wfLinks}
                    on-wf-link-click={(link: WFLink) => {
                      this.c.onLinkClick(link);
                    }}
                  ></wf-toolbar>
                ),
              ];
            }
            return null;
          },
        }}
      >
        {this.c.complete && (
          <i-tabs
            class={[this.ns.be('', 'tab')]}
            name={this.c.model.drTab.source.name}
            on-on-click={this.onTabClick}
          >
            <i-tab-pane
              class={this.ns.be('', 'tab-item')}
              tab={this.c.model.drTab.source.name}
              label={this.c.model.drTab.source.editItemCaption}
              name={'mainForm'}
            >
              {formComponent}
            </i-tab-pane>
            {this.c.model.drTab.pages.map(page => {
              const drPage = this.c.drPages[page.source.name];
              return (
                <i-tab-pane
                  class={this.ns.be('', 'tab-item')}
                  tab={this.c.model.drTab.source.name}
                  disabled={this.c.isNewData}
                  label={page.source.caption}
                  name={page.source.name}
                >
                  {!this.c.isNewData &&
                    this.lazyList.includes(page.source.name) &&
                    h('ViewShell', {
                      attrs: {
                        context: drPage.context,
                        params: drPage.params,
                        modal: { mode: ViewMode.EMBED },
                        modelPath: page.embedView.source.modelPath,
                        // 流程跟踪视图用
                        deName: this.c.model.appEntity.source.codeName,
                      },
                      on: {
                        neuronInit: this.c.nerve.onNeuronInit(page.source.name),
                      },
                      key: drPage.key,
                    })}
                </i-tab-pane>
              );
            })}
          </i-tabs>
        )}
      </view-base>
    );
  },
});
