import { IModal } from '@ibiz-template/runtime';
import { useWFDynaStartViewController } from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';

export const WFDynaStartView = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams> },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = useWFDynaStartViewController(proxy, props.modelPath);
    return { c };
  },
  render() {
    return (
      <view-base controller={this.c}>
        {this.c.complete && (
          <edit-form-control
            modelData={this.c.model.forms.get('form')}
            context={this.c.context}
            params={this.c.params}
            on-neuronInit={this.c.nerve.onNeuronInit('form')}
          ></edit-form-control>
        )}
      </view-base>
    );
  },
});
