import { FormTabPanelModel } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent, ref, VNode } from 'vue';

export default defineComponent({
  name: 'FormTabPanel',
  props: {
    modelData: {
      type: FormTabPanelModel,
      required: true,
    },
  },
  setup(props) {
    const ns = useNamespace('form-tab-panel');
    // tabs标识，嵌套时区分用
    const tabName = ref(props.modelData.source.name);
    return { ns, tabName };
  },
  render() {
    const defaultSlots: VNode[] = this.$slots.default || [];
    return (
      <tabs class={[this.ns.b()]} name={this.tabName}>
        {defaultSlots.map(slot => {
          const opts = slot.componentOptions!;
          const props = (opts.propsData || {}) as Record<string, unknown>;
          return (
            <tab-pane
              class={this.ns.b('tab-item')}
              tab={this.tabName}
              label={props.caption}
              name={slot.key}
            >
              {slot}
            </tab-pane>
          );
        })}
      </tabs>
    );
  },
});
