import { defineComponent } from 'vue';
import {
  getGridRadioProps,
  useGridCellEditor,
  useNamespace,
} from '@ibiz-template/vue-util';

export const IBizGridRadio = defineComponent({
  name: 'IBizGridRadio',
  props: getGridRadioProps(),
  setup(props) {
    const ns = useNamespace('grid-radio');
    const { isInfoMode, componentRef, onOperateChange, onChange } =
      useGridCellEditor(props.rowDataChange, props.rowSave, {
        isDelaySave: false,
      });

    return {
      ns,
      isInfoMode,
      componentRef,
      onOperateChange,
      onChange,
    };
  },
  render(h) {
    return (
      <div
        ref='componentRef'
        class={`${this.ns.b()} ibiz-grid-editor`}
        onDblclick={evt => evt.stopPropagation()}
        onClick={evt => evt.stopPropagation()}
      >
        {h('IBizRadio', {
          props: {
            ...this.$props,
            infoMode: this.isInfoMode,
          },
          on: {
            change: this.onChange,
            operate: this.onOperateChange,
          },
        })}
      </div>
    );
  },
});
