import {
  ContainerPortletController,
  CustomPortletController,
  DashboardController,
  IPortletPartProvider,
} from '@ibiz-template/controller';
import { CustomPortletModel, PortletPartModel } from '@ibiz-template/model';

/**
 * 数据看板成员自定义适配器
 *
 * @author lxm
 * @date 2022-10-19 15:10:44
 * @export
 * @class CustomPortletProvider
 */
export class CustomPortletProvider implements IPortletPartProvider {
  component: string = 'PortletPart';

  async createController(
    portletModel: PortletPartModel,
    dashboard: DashboardController,
    parent?: ContainerPortletController,
  ): Promise<CustomPortletController> {
    const c = new CustomPortletController(
      portletModel as CustomPortletModel,
      dashboard,
      parent,
    );
    await c.init();
    return c;
  }
}
