import {
  IGridColumnProvider,
  GridController,
  GridUAColumnController,
} from '@ibiz-template/controller';
import { GridUAColumnModel } from '@ibiz-template/model';
/**
 * 表格操作列适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class GridUAColumnProvider
 * @implements {IGridColumnProvider}
 */
export class GridUAColumnProvider implements IGridColumnProvider {
  component: string = 'GridUAColumn';

  async createController(
    columnModel: GridUAColumnModel,
    grid: GridController,
  ): Promise<GridUAColumnController> {
    const c = new GridUAColumnController(columnModel, grid);
    await c.init();
    return c;
  }
}
