import { ControlController } from '@ibiz-template/controller';
import { EChartsOption, EChartsType } from 'echarts';
import { ChartModel } from '@ibiz-template/model';
import { ChartNerve } from './nerve/chart-nerve';
import { ChartService } from '../service/chart-service';
export declare class ChartController extends ControlController<ChartModel> {
    /**
     * 图表神经系统
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:02
     * @type {ChartNerve}
     */
    nerve: ChartNerve;
    /**
     * 图表服务
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:13
     * @type {ChartService}
     */
    service: ChartService;
    /**
     * 图表实例
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:45
     * @type {(EChartsType | null)}
     */
    chart: EChartsType | null;
    /**
     * 图表id
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:22
     * @type {string}
     */
    chartId: string;
    /**
     * 图表静态配置
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:32
     * @type {EChartsOption}
     */
    chartStaticOption: EChartsOption;
    /**
     * 数据集合
     *
     * @author zhanghengfeng
     * @date 2023-04-07 16:04:34
     * @type {IData[]}
     */
    items: IData[];
    /**
     * 请求参数
     *
     * @author zhanghengfeng
     * @date 2023-04-07 16:04:28
     */
    queryParams: {
        page: number;
        size: number;
        query: string;
    };
    /**
     * 图表部件宽度
     *
     * @author zhanghengfeng
     * @date 2023-04-11 15:04:23
     * @type {string}
     */
    width: string;
    /**
     * 图表部件高度
     *
     * @author zhanghengfeng
     * @date 2023-04-11 15:04:37
     * @type {string}
     */
    height: string;
    /**
     * 创建图表神经系统
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:24
     * @protected
     * @return {*}  {ChartNerve}
     */
    protected createNerve(): ChartNerve;
    /**
     * 初始化配置
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:41
     * @protected
     * @return {*}  {Promise<void>}
     */
    protected onInit(): Promise<void>;
    /**
     * 重新渲染图表
     *
     * @author zhanghengfeng
     * @date 2023-04-03 18:04:35
     */
    resizeChart(): void;
    /**
     * 初始化图表静态配置
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:52
     */
    initChartStaticOption(): void;
    /**
     * 加载数据
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:13
     * @param {IParams} params
     */
    load(): Promise<void>;
    destroy(): void;
}
