var re = Object.defineProperty;
var le = (e, t, s) => t in e ? re(e, t, { enumerable: !0, configurable: !0, writable: !0, value: s }) : e[t] = s;
var I = (e, t, s) => (le(e, typeof t != "symbol" ? t + "" : t, s), s);
import { IndexViewModel as ce, ViewType as de, ModelUtil as ue } from "@ibiz-template/model";
import { GridFieldColumnController as q, GridRowController as me, WFStepTraceViewController as pe, UploadEditorController as H, WFDynaEditView3Controller as he } from "@ibiz-template/controller";
import { defineComponent as U, computed as L, h as a, getCurrentInstance as O, ref as b, watch as x, toRefs as _ } from "vue";
import { useNamespace as E, useViewController as X, usePropsWatch as J, getUploadProps as fe, getEditorEmits as Q, getGridUploadProps as G, getGridEditorEmits as R, useClickOutside as be, useEventListener as ve, getInputProps as ye, getGridInputProps as we, useGridCellEditor as ge, useWFStepTraceViewController as Fe, useEditView3Controller as Ce } from "@ibiz-template/vue-util";
import { colorBlend as Ue, HttpError as K, isImage as Ee, uploadFile as Se, RuntimeError as xe } from "@ibiz-template/core";
import { getCookie as ke, createUUID as z } from "qx-util";
import { debounce as Ie } from "lodash-es";
import { ViewMode as Y, UIActionHandler as Z, PluginStaticResource as Te } from "@ibiz-template/runtime";
const Pe = U({
  name: "CodeListGridColumn",
  props: {
    controller: {
      type: q,
      required: !0
    },
    row: {
      type: me,
      required: !0
    }
  },
  setup(e) {
    const t = E("grid-field-column"), s = L(() => {
      var c;
      if (e.controller.model.source.cLConvertMode !== "FRONT")
        return [];
      const n = e.row.data[e.controller.model.codeName];
      return (c = e.controller.codeListItems) != null && c.length && n ? n.split(",").map((m) => {
        const p = e.controller.codeListItems.find((f) => f.value === m);
        if (p) {
          const f = p.color || "#515a6e";
          return {
            text: p.text,
            colorStyle: t.cssVarBlock({
              color: f,
              "border-color": f,
              "bg-color": Ue(f, "#fff")
            })
          };
        }
      }).filter(Boolean) : [];
    }), o = (n) => {
      e.controller.isLinkColumn && e.controller.openLinkView(e.row, n);
    }, i = L(() => {
      let n = "";
      switch (e.controller.model.align) {
        case "LEFT":
          n = "flex-start";
          break;
        case "RIGHT":
          n = "flex-end";
          break;
        default:
          n = "center";
          break;
      }
      return t.cssVarBlock({
        "justify-content": n
      });
    });
    return {
      ns: t,
      alignStyle: i,
      selectedItems: s,
      onCellClick: o
    };
  },
  render() {
    const e = this.controller, t = this.row.data[e.model.codeName];
    return a("div", {
      class: [this.ns.b(), e.isLinkColumn && this.ns.m("link-column")],
      style: this.alignStyle,
      on: {
        click: this.onCellClick
      }
    }, [this.selectedItems.length > 0 ? this.selectedItems.map((s) => a("span", {
      class: this.ns.e("code-list-item"),
      style: s.colorStyle
    }, [s.text])) : a("span", {
      class: this.ns.e("text")
    }, [t])]);
  }
});
class Le extends pe {
  constructor() {
    super(...arguments);
    /**
     * 流程图url
     *
     * @type {string}
     * @memberof PresetWFChartViewController
     */
    I(this, "imgSrc");
  }
  async getUIData() {
    const s = Object.assign(this.context.clone(), this.params), o = await this.entityService.wf.getWFProcessDiagram(s), i = new Blob([o.data]);
    this.imgSrc = URL.createObjectURL(i);
  }
}
const Ne = U({
  name: "PresetWFChartView",
  props: {
    context: Object,
    params: {
      type: Object
    },
    modelPath: {
      type: String,
      required: !0
    },
    modal: {
      type: Object
    },
    deName: {
      type: String,
      required: !0
    }
  },
  setup(e) {
    const t = E("preset-wf-chart-view"), {
      proxy: s
    } = O(), o = X(s, (i, n) => new Le(e.modelPath, i, n));
    return J(s, "deName", o.setDeName.bind(o)), {
      c: o,
      ns: t
    };
  },
  render() {
    return a("div", {
      class: this.ns.b()
    }, [a("img", {
      attrs: {
        src: this.c.imgSrc
      }
    })]);
  }
});
const Ae = U({
  name: "WFToolbar",
  props: {
    wfLinks: {
      type: Array,
      required: !0
    }
  },
  setup(e, {
    emit: t
  }) {
    return {
      ns: E("wf-toolbar"),
      handleClick: async (i, n) => {
        t("wf-link-click", i, n);
      }
    };
  },
  render() {
    const e = this.wfLinks || [];
    return a("div", {
      class: `${this.ns.b()}`
    }, [e.length > 0 && e.map((t) => {
      const s = t.sequenceFlowName == "驳回" || t.sequenceFlowName == "取消";
      return a("div", {
        key: t.sequenceFlowId,
        class: [this.ns.e("item"), s ? this.ns.em("item", "reject") : ""]
      }, [a("i-button", {
        attrs: {
          title: t.sequenceFlowName
        },
        on: {
          click: (o) => this.handleClick(t, o)
        }
      }, [t.sequenceFlowName || ""])]);
    })]);
  }
}), De = typeof btoa == "function", $ = typeof Buffer == "function";
typeof TextDecoder == "function" && new TextDecoder();
const W = typeof TextEncoder == "function" ? new TextEncoder() : void 0, Be = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=", P = Array.prototype.slice.call(Be);
((e) => {
  let t = {};
  return e.forEach((s, o) => t[s] = o), t;
})(P);
const k = String.fromCharCode.bind(String);
typeof Uint8Array.from == "function" && Uint8Array.from.bind(Uint8Array);
const Oe = (e) => e.replace(/=/g, "").replace(/[+\/]/g, (t) => t == "+" ? "-" : "_"), Me = (e) => {
  let t, s, o, i, n = "";
  const c = e.length % 3;
  for (let l = 0; l < e.length; ) {
    if ((s = e.charCodeAt(l++)) > 255 || (o = e.charCodeAt(l++)) > 255 || (i = e.charCodeAt(l++)) > 255)
      throw new TypeError("invalid character found");
    t = s << 16 | o << 8 | i, n += P[t >> 18 & 63] + P[t >> 12 & 63] + P[t >> 6 & 63] + P[t & 63];
  }
  return c ? n.slice(0, c - 3) + "===".substring(c) : n;
}, ee = De ? (e) => btoa(e) : $ ? (e) => Buffer.from(e, "binary").toString("base64") : Me, _e = $ ? (e) => Buffer.from(e).toString("base64") : (e) => {
  let s = [];
  for (let o = 0, i = e.length; o < i; o += 4096)
    s.push(k.apply(null, e.subarray(o, o + 4096)));
  return ee(s.join(""));
}, Ge = (e) => {
  if (e.length < 2) {
    var t = e.charCodeAt(0);
    return t < 128 ? e : t < 2048 ? k(192 | t >>> 6) + k(128 | t & 63) : k(224 | t >>> 12 & 15) + k(128 | t >>> 6 & 63) + k(128 | t & 63);
  } else {
    var t = 65536 + (e.charCodeAt(0) - 55296) * 1024 + (e.charCodeAt(1) - 56320);
    return k(240 | t >>> 18 & 7) + k(128 | t >>> 12 & 63) + k(128 | t >>> 6 & 63) + k(128 | t & 63);
  }
}, Re = /[\uD800-\uDBFF][\uDC00-\uDFFFF]|[^\x00-\x7F]/g, $e = (e) => e.replace(Re, Ge), j = $ ? (e) => Buffer.from(e, "utf8").toString("base64") : W ? (e) => _e(W.encode(e)) : (e) => ee($e(e)), te = (e, t = !1) => t ? Oe(j(e)) : j(e);
function ze(e, t, s) {
  var T;
  const o = b([]), i = b({
    Authorization: `Bearer ${ke("access_token")}`
  }), n = b(""), c = b(""), l = {
    count: 0,
    cacheFiles: []
    // iview上传过程中不能改default-file-list,所以需要缓存
  }, u = (T = s.editorParams) == null ? void 0 : T.blackList;
  let m = [];
  u && typeof u == "string" && (m = u.split(",")), x(
    () => e.value,
    (r) => {
      o.value = r ? JSON.parse(r) : [];
    },
    { immediate: !0 }
  ), x(
    () => e.data,
    (r) => {
      if (r) {
        const d = s.calcBaseUrl(r);
        n.value = d.uploadUrl, c.value = d.downloadUrl;
      }
    },
    { immediate: !0, deep: !0 }
  ), x(
    o,
    (r) => {
      r != null && r.length && c.value && r.forEach((d) => {
        d.url = d.url || c.value.replace("%fileId%", d.id);
      });
    },
    { immediate: !0 }
  ), x(
    c,
    (r) => {
      r && o.value.length && o.value.forEach((d) => {
        d.url = c.value.replace("%fileId%", d.id);
      });
    },
    { immediate: !0 }
  );
  const p = () => {
    const r = [...o.value, ...l.cacheFiles], d = r.length > 0 ? JSON.stringify(r.map((v) => ({ name: v.name, id: v.id }))) : null;
    l.cacheFiles = [], t(d);
  }, f = (r) => {
    const d = r.name.trim().toLowerCase();
    if (m.some((g) => d.endsWith(`.${g}`)))
      return ibiz.message.error(`不可上传 ${m.join("、")}类型的文件！`), !1;
    l.count += 1;
  }, F = (r) => {
    r && (l.cacheFiles.push({
      name: r.filename,
      id: r.fileid
    }), l.count -= 1, l.count === 0 && p());
  }, C = (r, d) => {
    throw l.count -= 1, new K({
      response: { data: d, status: r.status }
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
    });
  }, S = (r) => {
    if (e.disabled)
      return;
    const d = o.value.findIndex((v) => v.id === r.id);
    d !== -1 && o.value.splice(d, 1), p();
  }, y = (r) => {
    const d = r.url || c.value.replace("%fileId%", r.id);
    s.fileDownload({ url: d, name: r.name });
  }, h = b(!1), w = b(""), N = b("");
  return {
    uploadUrl: n,
    downloadUrl: c,
    headers: i,
    files: o,
    onDownload: y,
    onError: C,
    onRemove: S,
    onSuccess: F,
    beforeUpload: f,
    showModal: h,
    modalTitle: w,
    iframeUrl: N,
    onModalCancel: () => {
      h.value = !1, w.value = "", N.value = "";
    },
    previewFile: (r) => {
      h.value = !0, w.value = r.name;
      const d = window.Environment.previewFileUrl;
      if (d) {
        const v = encodeURIComponent(
          te(
            `${window.location.origin}${r.url}?fullfilename=${r.name}`
          )
        );
        N.value = `${d}/onlinePreview?url=${v}`;
      }
    }
  };
}
const We = U({
  name: "SyFileUpload",
  props: fe(),
  emits: Q(),
  setup(e, {
    emit: t
  }) {
    const s = E("sy-file-upload"), o = e.controller, {
      uploadUrl: i,
      headers: n,
      files: c,
      onDownload: l,
      onError: u,
      onRemove: m,
      onSuccess: p,
      beforeUpload: f,
      showModal: F,
      modalTitle: C,
      iframeUrl: S,
      onModalCancel: y,
      previewFile: h
    } = ze(e, (w) => {
      t("change", w);
    }, o);
    return {
      ns: s,
      c: o,
      uploadUrl: i,
      headers: n,
      files: c,
      onDownload: l,
      onError: u,
      onRemove: m,
      onSuccess: p,
      beforeUpload: f,
      showModal: F,
      modalTitle: C,
      iframeUrl: S,
      onModalCancel: y,
      previewFile: h
    };
  },
  render(e) {
    return e("div", {
      class: [this.ns.b(), this.disabled ? this.ns.m("disabled") : "", this.readonly ? this.ns.m("readonly") : ""]
    }, [e("IUpload", {
      ref: "fileUpload",
      props: {
        action: this.uploadUrl,
        headers: this.headers,
        disabled: this.disabled,
        "default-file-list": this.files,
        multiple: this.c.model.multiple,
        type: this.c.model.isDrag ? "drag" : "select",
        accept: this.c.model.accept,
        "before-upload": this.beforeUpload,
        "on-success": this.onSuccess,
        "on-error": this.onError,
        "on-remove": this.onRemove,
        "on-preview": this.onDownload,
        "show-upload-list": !1
      }
    }, [this.c.model.isDrag ? e("div", {
      class: this.ns.bm("box", "drag")
    }, [e("i-icon", {
      attrs: {
        type: "md-cloud-upload"
      }
    }), e("div", {
      class: this.ns.be("box", "title")
    }, [e("span", ["将文件拖到此处，或"]), e("span", ["点击上传"])])]) : e("i-button", {
      attrs: {
        icon: "ios-cloud-upload-outline"
      },
      class: this.ns.bm("box", "select")
    }, ["上传文件"])]), e("div", {
      class: this.ns.b("file-list")
    }, [this.files.map((t) => e("div", {
      class: this.ns.b("file-item"),
      key: t.id
    }, [e("div", {
      class: this.ns.b("file-item-right")
    }, [e("div", {
      class: this.ns.b("file-item-right-title"),
      on: {
        click: () => this.previewFile(t)
      }
    }, [t.name]), e("div", {
      class: this.ns.b("file-item-right-action")
    }, [e("i-icon", {
      attrs: {
        type: "md-download"
      },
      on: {
        click: () => this.onDownload(t)
      }
    }), e("i-icon", {
      attrs: {
        type: "md-eye"
      },
      on: {
        click: () => this.previewFile(t)
      }
    }), this.disabled || this.readonly ? null : e("i-icon", {
      attrs: {
        type: "md-close"
      },
      on: {
        click: () => this.onRemove(t)
      }
    })])])]))]), e("i-modal", {
      attrs: {
        value: this.showModal,
        title: this.modalTitle,
        "class-name": this.ns.b("modal"),
        width: "70%",
        transfer: !1,
        "footer-hide": !0
      },
      on: {
        "on-cancel": this.onModalCancel
      }
    }, [e("iframe", {
      class: this.ns.b("iframe"),
      attrs: {
        src: this.iframeUrl
      }
    })])]);
  }
});
function B(e, t) {
  if (e.url = t.replace("%fileId%", e.id), e.status || (e.status = "finished"), !e.fileName) {
    const s = e.name.lastIndexOf(".");
    e.fileName = e.name.substring(0, s), e.fileExt = e.name.substring(s), e.isImage = Ee(e.name);
  }
  return e;
}
function se(e) {
  const t = b(""), s = b(""), o = b([]);
  return x(
    e.data,
    (i) => {
      if (i) {
        const n = e.controller.value.calcBaseUrl(i);
        t.value = n.uploadUrl, s.value = n.downloadUrl;
      }
    },
    { immediate: !0, deep: !0 }
  ), x(
    e.value,
    (i) => {
      o.value = i ? JSON.parse(i) : [], o.value.length && s.value && o.value.forEach((n) => {
        B(n, s.value);
      });
    },
    { immediate: !0 }
  ), x(
    s,
    (i) => {
      i && o.value.length && o.value.forEach((n) => {
        B(n, i);
      });
    },
    { immediate: !0 }
  ), {
    downloadUrl: s,
    uploadUrl: t,
    valueList: o
  };
}
function oe(e) {
  var M, T;
  const t = b("undo"), s = b([]), { downloadUrl: o, value: i, uploadUrl: n, controller: c } = e, l = (T = (M = c == null ? void 0 : c.value) == null ? void 0 : M.editorParams) == null ? void 0 : T.blackList;
  let u = [];
  l && typeof l == "string" && (u = l.split(",")), x(
    i,
    (r) => {
      r.length > 0 && (s.value = [], r.forEach((d) => {
        s.value.push(B(d, o.value));
      }));
    },
    {
      immediate: !0,
      deep: !0
    }
  );
  const m = (r, d) => {
    const v = [];
    return d.forEach((g, A) => {
      const D = g.name.trim().toLowerCase();
      if (u.some((ae) => D.endsWith(`.${ae}`))) {
        v.push(A);
        return;
      }
      s.value.push({
        name: g.name,
        status: g.status,
        percentage: g.percentage,
        id: g.uid,
        url: ""
      });
    }), v.length === d.length ? (ibiz.message.error(`不可上传 ${u.join("、")}类型的文件！`), !1) : (v.length && (v.forEach((g) => {
      r.splice(g, 1), d.splice(g, 1);
    }), ibiz.message.error(`不可上传 ${u.join("、")}类型的文件！`)), !0);
  }, p = (r) => {
    r.forEach((d) => {
      s.value.find((v) => v.id === d.uid ? (v.percentage = d.percentage, !0) : !1);
    });
  }, f = (r, d) => {
    r.forEach((v) => {
      s.value.find((g) => g.id === v.uid ? (g.status = v.status, g.id = d.data.fileid, g.name = d.data.filename, B(g, o.value), !0) : !1);
    });
  }, F = (r, d) => {
    var g;
    r.forEach((A) => {
      s.value.find((D) => D.id === A.uid ? (D.status = A.status, !0) : !1);
    });
    const v = new K(d);
    ibiz.notification.error({
      title: (g = v.status) == null ? void 0 : g.toString(),
      desc: v.message,
      duration: 10
    });
  }, C = (r) => {
    s.value = s.value.filter((d) => d.status === "finished"), t.value = "done";
  }, S = () => {
    Se({
      multiple: e.multiple,
      accept: e.accept,
      uploadUrl: n.value,
      beforeUpload: m,
      progress: p,
      success: f,
      error: F,
      finish: C
    });
  }, y = b(!1), h = b(""), w = b("");
  return {
    selectFile: S,
    fileList: s,
    uploadState: t,
    showModal: y,
    modalTitle: h,
    iframeUrl: w,
    onModalCancel: () => {
      y.value = !1, h.value = "", w.value = "";
    },
    previewFile: (r) => {
      y.value = !0, h.value = r.name;
      const d = window.Environment.previewFileUrl;
      if (d) {
        const v = encodeURIComponent(
          te(
            `${window.location.origin}${r.url}?fullfilename=${r.name}`
          )
        );
        w.value = `${d}/onlinePreview?url=${v}`;
      }
    }
  };
}
const je = U({
  name: "SyGridFileUpload",
  props: G(),
  setup(e) {
    const t = E("sy-grid-file-upload"), {
      value: s,
      data: o,
      controller: i
    } = _(e), {
      downloadUrl: n,
      uploadUrl: c,
      valueList: l
    } = se({
      value: s,
      data: o,
      controller: i
    }), {
      fileList: u,
      showModal: m,
      modalTitle: p,
      iframeUrl: f,
      previewFile: F,
      onModalCancel: C
    } = oe({
      downloadUrl: n,
      uploadUrl: c,
      value: l
    });
    return {
      ns: t,
      fileList: u,
      showModal: m,
      modalTitle: p,
      iframeUrl: f,
      downloadFile: (y) => {
        e.controller.fileDownload(y);
      },
      previewFile: F,
      onModalCancel: C
    };
  },
  render() {
    return a("grid-editor", {
      attrs: {
        disabled: this.disabled,
        readonly: this.readonly
      },
      class: [this.ns.b(), this.disabled ? this.ns.m("disabled") : "", this.readonly ? this.ns.m("readonly") : ""]
    }, [a("div", {
      class: this.ns.b("file-list")
    }, [this.fileList.map((e) => a("div", {
      class: this.ns.b("file-item"),
      key: e.id
    }, [a("div", {
      class: this.ns.b("file-item-title"),
      on: {
        click: () => this.previewFile(e)
      }
    }, [e.name]), a("div", {
      class: this.ns.b("file-item-action")
    }, [a("i-icon", {
      attrs: {
        type: "md-download"
      },
      on: {
        click: () => this.downloadFile(e)
      }
    }), a("i-icon", {
      attrs: {
        type: "md-eye"
      },
      on: {
        click: () => this.previewFile(e)
      }
    })])]))]), a("i-modal", {
      attrs: {
        value: this.showModal,
        title: this.modalTitle,
        "class-name": this.ns.b("modal"),
        width: "70%",
        transfer: !1,
        "footer-hide": !0
      },
      on: {
        "on-cancel": this.onModalCancel
      }
    }, [a("iframe", {
      class: this.ns.b("iframe"),
      attrs: {
        src: this.iframeUrl
      }
    })])]);
  }
}), Ve = U({
  name: "SyGridFileUploadContainer",
  props: G(),
  emits: R(),
  render(e) {
    return this.disabled || this.readonly ? e("SyGridFileUpload", {
      props: {
        ...this.$props
      }
    }) : e("SyEditGridFileUpload", {
      props: {
        ...this.$props
      },
      on: {
        change: (t, s) => {
          this.$emit("change", t, s);
        },
        rowSave: () => {
          this.$emit("rowSave");
        }
      }
    });
  }
});
const qe = U({
  name: "SyEditGridFileUploadPopover",
  props: {
    uploadUrl: {
      type: String,
      required: !0
    },
    downloadUrl: {
      type: String,
      required: !0
    },
    value: {
      type: Array,
      required: !0
    },
    controller: {
      type: H,
      required: !0
    }
  },
  emits: {
    close: (e) => !0
  },
  setup(e, {
    emit: t
  }) {
    const s = E("sy-edit-grid-file-upload-popover"), {
      downloadUrl: o,
      value: i,
      uploadUrl: n,
      controller: c
    } = _(e), {
      fileList: l,
      uploadState: u,
      selectFile: m
    } = oe({
      downloadUrl: o,
      value: i,
      uploadUrl: n,
      controller: c
    }), p = b(), f = b(!1), F = be(p, async (y) => {
      t("close", {
        isModified: f.value,
        resultFiles: l.value
      });
    });
    return x(u, (y) => {
      y === "done" ? (f.value = !0, F.proceed()) : y === "loading" && F.pause();
    }), {
      ns: s,
      componentRef: p,
      fileList: l,
      deleteFile: (y) => {
        const h = l.value.findIndex((w) => w.id === y.id);
        l.value.splice(h, 1), f.value = !0;
      },
      selectFile: m,
      downloadFile: (y) => {
        e.controller.fileDownload(y);
      }
    };
  },
  render() {
    return a("div", {
      ref: "componentRef",
      style: "width:300px",
      class: this.ns.b()
    }, [a("div", {
      class: this.ns.b("file-list")
    }, [this.fileList.map((e) => a("div", {
      class: this.ns.b("file-item"),
      key: e.id
    }, [a("div", {
      class: this.ns.b("file-item-title"),
      on: {
        click: () => this.downloadFile(e)
      }
    }, [e.name]), a("div", {
      class: this.ns.b("file-item-action")
    }, [a("i-icon", {
      attrs: {
        type: "md-close"
      },
      on: {
        click: () => this.deleteFile(e)
      }
    })])]))]), a("div", {
      on: {
        click: () => this.selectFile()
      },
      class: this.ns.e("button")
    }, [a("i-icon", {
      attrs: {
        type: "md-add"
      }
    }), "添加文件"])]);
  }
});
const He = U({
  name: "SyEditGridFileUpload",
  props: G(),
  emits: R(),
  setup(e, {
    emit: t
  }) {
    const s = E("sy-edit-grid-file-upload"), {
      value: o,
      data: i,
      controller: n
    } = _(e), {
      downloadUrl: c,
      uploadUrl: l,
      valueList: u
    } = se({
      value: o,
      data: i,
      controller: n
    }), m = b(), p = async () => {
      if (!m.value)
        throw new xe("容器元素不存在");
      const f = m.value.$el, F = f.offsetHeight, C = ibiz.overlay.createPopover((h) => h(qe, {
        props: {
          value: u.value,
          uploadUrl: l.value,
          downloadUrl: c.value,
          controller: n.value
        },
        on: {
          close: (w) => {
            C.dismiss(w);
          }
        }
      }), void 0, {
        noArrow: !0,
        placement: "bottom-start",
        offsetOpts: {
          mainAxis: -F,
          crossAxis: 0
        }
      });
      await C.present(f);
      const {
        isModified: S,
        resultFiles: y
      } = await C.onWillDismiss();
      if (S) {
        const h = y.length > 0 ? JSON.stringify(y.map((w) => ({
          name: w.name,
          id: w.id
        }))) : null;
        t("change", h), t("rowSave");
      }
    };
    return ve(m, "click", (f) => {
      e.disabled || p();
    }), {
      ns: s,
      valueList: u,
      componentRef: m
    };
  },
  render() {
    return a("grid-editor", {
      attrs: {
        disabled: this.disabled,
        readonly: this.readonly
      },
      ref: "componentRef",
      class: this.ns.b()
    }, [a("div", {
      class: this.ns.b("file-list")
    }, [this.valueList.map((e) => a("div", {
      class: this.ns.b("file-item"),
      key: e.id
    }, [a("div", {
      class: this.ns.b("file-item-title")
    }, [e.name])]))])]);
  }
});
U({
  name: "SyInput",
  props: ye(),
  emits: Q(),
  setup(e, {
    emit: t
  }) {
    const s = E("input"), i = e.controller.model, n = b(), c = b(2);
    i.editorType === "TEXTAREA_10" && (c.value = 10);
    const l = L(() => {
      switch (i.editorType) {
        case "TEXTBOX":
          return "text";
        case "PASSWORD":
          return "password";
        case "TEXTAREA":
        case "TEXTAREA_10":
          return "textarea";
        default:
          return "string";
      }
    }), u = b("");
    x(() => e.value, (h, w) => {
      h !== w && (h ? u.value = h : u.value = "");
    }, {
      immediate: !0
    });
    let m = !1, p, f;
    const F = Ie((h) => {
      f !== h.target.value && t("change", h.target.value), f = void 0, m = !1, p && p();
    }, 300, {
      leading: !0
    }), C = (h) => {
      m = !0, F(h);
    }, S = (h) => {
      h && h.code === "Enter" && m && (p = () => {
        n.value.$el.dispatchEvent(h);
      });
    }, y = () => {
      f = n.value.currentValue, t("change", f);
    };
    return e.autoFocus && x(n, (h) => {
      h && h.$el.getElementsByTagName("input")[0].focus();
    }), {
      ns: s,
      rows: c,
      type: l,
      currentVal: u,
      handleChange: C,
      handleKeyUp: S,
      handleBlur: y,
      inputRef: n
    };
  },
  render() {
    return a("div", {
      class: [this.ns.b(), this.ns.b("sy-input"), this.ns.is("textarea", Object.is(this.type, "textarea")), this.disabled ? this.ns.m("disabled") : "", this.readonly ? this.ns.m("readonly") : ""]
    }, [this.readonly ? this.currentVal : a("i-input", {
      ref: "inputRef",
      attrs: {
        value: this.currentVal,
        placeholder: this.controller.placeHolder,
        type: this.type,
        rows: this.rows,
        disabled: this.disabled,
        autosize: Object.is(this.type, "textarea")
      },
      on: {
        "on-change": this.handleChange,
        "on-blur": this.handleBlur
      },
      nativeOn: {
        keyup: this.handleKeyUp
      },
      class: this.ns.b("input")
    }, [this.controller.model.unitName && a("i", {
      class: this.ns.e("unit"),
      slot: "suffix"
    }, [this.controller.model.unitName])])]);
  }
});
U({
  name: "SyGridInput",
  props: we(),
  emits: R(),
  setup(e, {
    emit: t
  }) {
    const s = E("grid-input"), {
      isInfoMode: o,
      autoFocus: i,
      componentRef: n,
      onOperateChange: c,
      onChange: l
    } = ge(e, {
      emit: t
    });
    return {
      ns: s,
      isInfoMode: o,
      autoFocus: i,
      componentRef: n,
      onOperateChange: c,
      onChange: l
    };
  },
  render(e) {
    return e("grid-editor", {
      attrs: {
        disabled: this.disabled,
        readonly: this.readonly
      },
      ref: "componentRef",
      class: `${this.ns.b()}`
    }, [e("SyInput", {
      props: {
        ...this.$props,
        readonly: this.isInfoMode,
        disabled: this.disabled,
        autoFocus: this.autoFocus
      },
      on: {
        change: this.onChange,
        operate: this.onOperateChange
      }
    })]);
  }
});
function V(e, t) {
  return a("div", {
    class: e.e("logo")
  }, [t.appIconPath ? a("img", {
    class: e.e("logo-img"),
    attrs: {
      src: t.appIconPath
    }
  }) : null, a("div", {
    class: e.e("logo-caption")
  }, [t.caption])]);
}
const Xe = U({
  name: "UserAppLayout",
  props: {
    model: {
      type: ce,
      required: !0
    },
    // 视图是否完成加载
    isComplete: {
      type: Boolean,
      default: !1
    },
    // 是否显示分页导航
    isShowTabPageExp: {
      type: Boolean,
      default: !1
    }
  },
  setup(e, {
    emit: t
  }) {
    const s = E("layout"), o = b(!1), i = () => {
      o.value = !o.value, t("onCollapseChange", o.value);
    }, n = L(() => e.model.source.blankMode === !0), c = L(() => !!(window.Environment.manualdownloadurl || ibiz.env.manualdownloadurl));
    return {
      ns: s,
      collapseChange: o,
      isBlank: n,
      collapseMenus: i,
      isShowDownload: c,
      downloadUserBook: () => {
        const u = window.Environment.manualdownloadurl || ibiz.env.manualdownloadurl;
        u ? window.open(u) : console.log("环境变量里没有manualdownloadurl");
      }
    };
  },
  render() {
    return this.isComplete ? a("i-layout", {
      class: [this.ns.b(), this.isBlank ? this.ns.m("blank") : "", this.ns.is("collapse", this.collapseChange), this.ns.is("tab", this.isShowTabPageExp), "user-layout"]
    }, [a("i-sider", {
      attrs: {
        "hide-trigger": !0,
        value: this.collapseChange
      },
      class: [this.ns.b("nav"), this.ns.is("collapse", this.collapseChange)]
    }, [V(this.ns, this.model), this.$slots.menu]), a("i-layout", {
      class: [this.ns.b("content")]
    }, [a("i-header", {
      class: this.ns.b("header")
    }, [a("div", {
      class: this.ns.be("header", "left")
    }, [V(this.ns, this.model), a("div", {
      class: this.ns.be("header", "collapse-icon")
    }, [this.collapseChange ? a("ion-icon", {
      attrs: {
        src: "./assets/img/menu-unfold.svg"
      },
      on: {
        click: () => this.collapseMenus()
      }
    }) : a("ion-icon", {
      attrs: {
        src: "./assets/img/menu-fold.svg"
      },
      on: {
        click: () => this.collapseMenus()
      }
    })]), this.model.source.mainMenuAlign === "TOP" ? a("i-menu", {
      class: this.ns.be("header", "menu"),
      attrs: {
        mode: "horizontal",
        "active-name": "1"
      }
    }) : null]), a("div", {
      class: this.ns.be("header", "right")
    }, [this.isShowDownload && a("div", {
      class: "user-download",
      on: {
        click: () => this.downloadUserBook()
      }
    }, ["用户手册下载"]), a("app-user")])]), a("i-content", {
      class: this.ns.be("content", "main")
    }, [this.$slots.tabPageExp, this.$slots.default])])]) : null;
  }
});
class Je {
  constructor() {
    I(this, "component", Ne);
  }
}
class Qe {
  constructor() {
    I(this, "component", Pe);
  }
  async createController(t, s) {
    const o = new q(t, s);
    return await o.init(), o;
  }
}
class Ke {
  constructor() {
    I(this, "component", "IndexView");
  }
}
const ie = U({
  name: "WFStepTraceGrid",
  props: {
    context: Object,
    params: {
      type: Object
    },
    modelPath: {
      type: String,
      required: !0
    },
    modal: {
      type: Object
    },
    deName: {
      type: String,
      required: !0
    }
  },
  setup(e) {
    const {
      proxy: t
    } = O(), s = Fe(t, e.modelPath);
    J(t, "deName", s.setDeName.bind(s));
    const o = E("wf-step-trace-grid"), i = b([]), n = (l, u, m = !1) => {
      l.identitylinks.length > 0 || l.comments.length > 0 && l.comments.forEach((p) => {
        m && p.type === "启动流程" || u.push({
          id: z(),
          nodeName: l.userTaskName,
          personName: p.authorName,
          time: p.time,
          content: p.type,
          comment: p.fullMessage
        });
      });
    };
    s.nerve.self.evt.on("mounted", () => {
      var l;
      s.data && ((l = s.data.usertasks) == null || l.forEach((u) => {
        if (u.usertasks && u.usertasks.length > 0) {
          const m = [];
          u.usertasks.forEach((p) => {
            n(p, m, !0);
          }), i.value.push({
            id: z(),
            nodeName: `${u.userTaskName}`,
            personName: "",
            time: "",
            content: "",
            comment: "",
            children: m,
            _showChildren: !0
          });
        } else
          n(u, i.value);
      }), i.value.sort((u, m) => Date.parse(u.time) - Date.parse(m.time)), console.log(1, i.value), console.log(2, s.data));
    });
    const c = b([{
      title: "处理环节",
      key: "nodeName",
      width: 180,
      resizable: !0,
      tree: !0
    }, {
      title: "处理人",
      key: "personName",
      width: 180,
      resizable: !0
    }, {
      title: "处理时间",
      key: "time",
      width: 180,
      resizable: !0
    }, {
      title: "处理内容",
      key: "content",
      width: 180,
      resizable: !0
    }, {
      title: "处理意见",
      key: "comment"
    }]);
    return {
      c: s,
      ns: o,
      gridData: i,
      columns: c
    };
  },
  render() {
    return a("div", {
      class: this.ns.b()
    }, [a("div", {
      class: this.ns.e("title")
    }, ["审批信息"]), a("i-table", {
      attrs: {
        "disabled-hover": !0,
        columns: this.columns,
        data: this.gridData,
        "row-key": "id"
      },
      class: this.ns.e("grid")
    })]);
  }
});
class Ye extends he {
  async calcWfToolbar() {
    await super.calcWfToolbar(), this.isEditable && this.wfLinks.unshift({
      sequenceFlowName: "保存",
      type: "FORM_SAVE"
    });
  }
  async onLinkClick(t) {
    t.type === "FORM_SAVE" ? await this.save() : super.onLinkClick(t);
  }
}
U({
  props: {
    context: Object,
    params: {
      type: Object
    },
    modelPath: {
      type: String,
      required: !0
    },
    modal: {
      type: Object
    }
  },
  setup(e) {
    const {
      proxy: t
    } = O(), s = X(t, (c, l) => new Ye(e.modelPath, c, l)), o = E(`view-${de.DE_WF_DYNA_EDIT_VIEW3}`.toLowerCase()), i = b(["mainForm"]);
    return {
      c: s,
      ns: o,
      onTabClick: (c) => {
        i.value.includes(c) || i.value.push(c);
      },
      lazyList: i
    };
  },
  render(e) {
    const t = [];
    if (this.c.complete) {
      const {
        activeForm: s
      } = this.c;
      s && this.c.providers[s.name] && t.push(e(this.c.providers[s.name].component, {
        props: {
          modelData: s,
          context: this.c.context,
          params: this.c.params
        },
        style: {
          height: "auto"
        },
        on: {
          neuronInit: this.c.nerve.onNeuronInit("form")
        }
      }));
    }
    if (this.c.complete && this.c.model.drTab.pages[0]) {
      const s = this.c.model.drTab.pages[0], o = this.c.drPages[s.source.name];
      t.push(e(ie, {
        attrs: {
          context: o.context,
          params: o.params,
          deName: this.c.model.appEntity.source.codeName,
          modal: this.modal,
          modelPath: s.embedView.source.modelPath
        }
      }));
    }
    return e("view-base", {
      attrs: {
        controller: this.c
      },
      scopedSlots: {
        toolbar: () => this.c.complete ? [this.c.wfLinks.length > 0 && e("wf-toolbar", {
          attrs: {
            wfLinks: this.c.wfLinks
          },
          on: {
            "wf-link-click": (s) => {
              this.c.onLinkClick(s);
            }
          }
        })] : null
      }
    }, [this.c.complete && e("i-tabs", {
      class: [this.ns.be("", "tab")],
      attrs: {
        name: this.c.model.drTab.source.name
      },
      on: {
        "on-click": this.onTabClick
      }
    }, [e("i-tab-pane", {
      class: this.ns.be("", "tab-item"),
      attrs: {
        tab: this.c.model.drTab.source.name,
        label: this.c.model.drTab.source.editItemCaption,
        name: "mainForm"
      }
    }, [t]), this.c.model.drTab.pages.map((s) => {
      const o = this.c.drPages[s.source.name];
      return e("i-tab-pane", {
        class: this.ns.be("", "tab-item"),
        attrs: {
          tab: this.c.model.drTab.source.name,
          disabled: this.c.isNewData,
          label: s.source.caption,
          name: s.source.name
        }
      }, [!this.c.isNewData && this.lazyList.includes(s.source.name) && e("ViewShell", {
        attrs: {
          context: o.context,
          params: o.params,
          modal: {
            mode: Y.EMBED
          },
          modelPath: s.embedView.source.modelPath,
          // 流程跟踪视图用
          deName: this.c.model.appEntity.source.codeName
        },
        on: {
          neuronInit: this.c.nerve.onNeuronInit(s.source.name)
        },
        key: o.key
      })]);
    })])]);
  }
});
U({
  name: "SyEditView3",
  props: {
    context: Object,
    params: {
      type: Object
    },
    modelPath: {
      type: String,
      required: !0
    },
    modal: {
      type: Object
    }
  },
  setup(e) {
    const {
      proxy: t
    } = O(), s = Ce(t, e.modelPath), o = E("view-deeditview3"), i = b(["mainForm"]);
    return {
      c: s,
      ns: o,
      onTabClick: (c) => {
        i.value.includes(c) || i.value.push(c);
      },
      lazyList: i
    };
  },
  render(e) {
    return e("view-base", {
      attrs: {
        controller: this.c
      }
    }, [this.c.complete && e("i-tabs", {
      class: [this.ns.be("", "tab")],
      attrs: {
        name: this.c.model.drTab.source.name
      },
      on: {
        "on-click": this.onTabClick
      }
    }, [e("i-tab-pane", {
      class: this.ns.be("", "tab-item"),
      attrs: {
        tab: this.c.model.drTab.source.name,
        label: this.c.model.drTab.source.editItemCaption,
        name: "mainForm"
      }
    }, [e("edit-form-control", {
      attrs: {
        modelData: this.c.model.form,
        context: this.c.context,
        params: this.c.params
      },
      style: {
        height: "auto"
      },
      on: {
        neuronInit: this.c.nerve.onNeuronInit(this.c.model.form.source.name)
      }
    }), e(ie, {
      attrs: {
        context: this.c.drPages[this.c.model.drTab.pages[0].source.name].context,
        params: this.c.drPages[this.c.model.drTab.pages[0].source.name].params,
        deName: this.c.model.appEntity.source.codeName,
        modal: this.modal,
        modelPath: this.c.model.drTab.pages[0].embedView.source.modelPath
      }
    })]), this.c.model.drTab.pages.map((t) => {
      const s = this.c.drPages[t.source.name];
      if (s)
        return e("i-tab-pane", {
          class: this.ns.be("", "tab-item"),
          attrs: {
            tab: this.c.model.drTab.source.name,
            disabled: this.c.isNewData,
            label: t.source.caption,
            name: t.source.name
          }
        }, [!this.c.isNewData && this.lazyList.includes(t.source.name) && e("ViewShell", {
          attrs: {
            context: s.context,
            params: s.params,
            modal: {
              mode: Y.EMBED
            },
            modelPath: t.embedView.source.modelPath,
            // 流程跟踪视图用
            deName: this.c.model.appEntity.source.codeName
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit(t.source.name)
          },
          key: s.key
        })]);
    })])]);
  }
});
class Ze {
  constructor() {
    I(this, "formEditor", "SyFileUpload");
    I(this, "gridEditor", "SyGridFileUploadContainer");
  }
  async createController(t, s) {
    const o = new H(t, s);
    return await o.init(), o;
  }
}
class et extends Z {
  async execAction(t, s, o, i, n) {
    if (o && o.length > 0) {
      const l = (await ibiz.entityService.getService("XQFBXQPS", s)).local.getList(s);
      o.forEach((u) => {
        const m = l.find((p) => p.srfkey === u.srfkey);
        m && (m.psjg = "10", u.psjg = "10");
      });
    }
    return {
      refresh: !1,
      closeView: !1
    };
  }
}
class tt {
  constructor() {
    I(this, "handler");
  }
  async getHandler() {
    return this.handler || (this.handler = new et()), this.handler;
  }
}
class st extends Z {
  async execAction(t, s, o, i, n) {
    if (o && o.length > 0) {
      const l = (await ibiz.entityService.getService("XQFBXQPS", s)).local.getList(s);
      o.forEach((u) => {
        const m = l.find((p) => p.srfkey === u.srfkey);
        m && (m.psjg = "20", u.psjg = "20");
      });
    }
    return {
      refresh: !1,
      closeView: !1
    };
  }
}
class ot {
  constructor() {
    I(this, "handler");
  }
  async getHandler() {
    return this.handler || (this.handler = new st()), this.handler;
  }
}
const it = new Te(import.meta.url), ft = {
  mateUrl: import.meta.url,
  install(e) {
    ue.getModelService().then((t) => {
      var o;
      ((o = t.app.userParams) == null ? void 0 : o.autoWidth) === "true" && document.getElementsByClassName("app")[0].classList.add("auto-width");
    }), it.loadStyle(["/style.css"]), ibiz.config.enableDataInfoBar = !1, ibiz.config.gridEditShowMode = "all", e.component("WfToolbar", Ae), ibiz.register.view.register(
      "VIEW_CUSTOM_SyWebIndexView",
      new Ke()
    ), ibiz.register.view.register(
      "VIEW_CUSTOM_PresetWFChartView",
      new Je()
    ), ibiz.register.gridColumn.register(
      "GRID_COLRENDER_CodeListGridColumn",
      new Qe()
    ), e.component("SyFileUpload", We), e.component("SyGridFileUpload", je), e.component("SyEditGridFileUpload", He), e.component("SyGridFileUploadContainer", Ve), ibiz.register.editor.register(
      "EDITOR_CUSTOMSTYLE_SyFileUpload",
      new Ze()
    ), e.component("AppLayout", Xe), ibiz.register.uiAction.register(
      "DEUIACTION_BatchApprovalOrdersId",
      new tt()
    ), ibiz.register.uiAction.register(
      "DEUIACTION_BatchNoApprovalOrdersId",
      new ot()
    );
  }
};
export {
  ft as default
};
