import { DatePickerEditorModel } from '@ibiz-template/model';
import {
  DateRangeEditorController,
  FormItemController,
  GridEditItemController,
  IEditorProvider,
} from '@ibiz-template/controller';

/**
 * 日期范围选择器编辑器适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class DatePickerEditorProvider
 * @implements {EditorProvider}
 */
export class DateRangeEditorProvider implements IEditorProvider {
  formEditor: string = 'IBizDateRange';

  gridEditor: string = 'IBizGridDateRange';

  async createController(
    editorModel: DatePickerEditorModel,
    parentController: FormItemController | GridEditItemController,
  ): Promise<DateRangeEditorController> {
    const c = new DateRangeEditorController(editorModel, parentController);
    await c.init();
    return c;
  }
}
