/* eslint-disable no-param-reassign */
import { defineComponent, ref } from 'vue';
import {
  getEditorEmits,
  getUploadProps,
  useNamespace,
} from '@ibiz-template/vue-util';
import '@ibiz-template/theme/style/components/editor/ibiz-image-upload/ibiz-image-upload.scss';
import { useIViewUpload } from '../use/use-iview-upload';

export const IBizImageUpload = defineComponent({
  name: 'IBizImageUpload',
  props: getUploadProps(),
  emits: getEditorEmits(),
  setup(props, { emit }) {
    const ns = useNamespace('image-upload');

    const c = props.controller;

    const {
      uploadUrl,
      headers,
      files,
      onDownload,
      onError,
      onRemove,
      onSuccess,
      beforeUpload,
    } = useIViewUpload(
      props,
      value => {
        emit('change', value);
      },
      c,
    );

    const dialogImageUrl = ref<string>('');
    const dialogVisible = ref<boolean>(false);

    const onDialogVisibleChange = (value: boolean) => {
      dialogVisible.value = value;
    };

    // 预览
    const onPreview = (file: IData) => {
      dialogImageUrl.value = file.url;
      dialogVisible.value = true;
    };

    return {
      ns,
      c,
      files,
      headers,
      uploadUrl,
      dialogImageUrl,
      dialogVisible,
      beforeUpload,
      onSuccess,
      onError,
      onRemove,
      onDownload,
      onDialogVisibleChange,
      onPreview,
    };
  },
  render() {
    // 编辑态展示
    let content = null;
    if (this.c.model.editorType === 'PICTURE_ONE') {
      if (this.files[0]) {
        const item = this.files[0];
        content = (
          <div class={this.ns.e('image-upload-list')}>
            <div key={item.id} class={this.ns.e('list-item')}>
              <img src={item.url} />
              <div class={this.ns.e('list-item-cover')}>
                <i-icon
                  class={this.ns.e('preview-icon')}
                  type='ios-eye-outline'
                  on-click={() => this.onPreview(item)}
                ></i-icon>
                <i-icon
                  class={this.ns.e('download-icon')}
                  type='ios-download-outline'
                  on-click={() => this.onDownload(item)}
                ></i-icon>
                <i-icon
                  class={this.ns.e('remove-icon')}
                  type='ios-trash-outline'
                  on-click={() => this.onRemove(item)}
                ></i-icon>
              </div>
            </div>
          </div>
        );
      }
    } else {
      content = (
        <div class={this.ns.e('image-upload-list')}>
          {this.files.map(item => (
            <div key={item.id} class={this.ns.e('list-item')}>
              <img src={item.url} />
              <div class={this.ns.e('list-item-cover')}>
                <i-icon
                  class={this.ns.e('preview-icon')}
                  type='ios-eye-outline'
                  on-click={() => this.onPreview(item)}
                ></i-icon>
                <i-icon
                  class={this.ns.e('download-icon')}
                  type='ios-download-outline'
                  on-click={() => this.onDownload(item)}
                ></i-icon>
                <i-icon
                  class={this.ns.e('remove-icon')}
                  type='ios-trash-outline'
                  on-click={() => this.onRemove(item)}
                ></i-icon>
              </div>
            </div>
          ))}
        </div>
      );
    }
    return (
      <div
        class={[
          this.ns.b(),
          this.disabled ? this.ns.m('disabled') : '',
          this.readonly ? this.ns.m('readonly') : '',
          this.c.style.width || this.c.style.height
            ? this.ns.m(this.c.model.editorType)
            : '',
        ]}
        style={this.c.style}
      >
        {content}
        {this.c.model.editorType === 'PICTURE_ONE' &&
        this.files.length >= 1 ? null : (
          <i-upload
            ref='imageUpload'
            action={this.uploadUrl}
            headers={this.headers}
            default-file-list={this.files}
            multiple={this.c.model.multiple}
            type={'drag'}
            accept={this.c.model.accept}
            show-upload-list={false}
            before-upload={this.beforeUpload}
            disabled={this.disabled}
            props={{
              'on-success': this.onSuccess,
              'on-error': this.onError,
              'on-remove': this.onRemove,
              'on-preview': this.onDownload,
            }}
          >
            <div class={this.ns.e('btn')}>
              <i-icon type='ios-add' size='30'></i-icon>
            </div>
          </i-upload>
        )}
        <i-modal
          class-name={this.ns.b('modal')}
          footer-hide={true}
          value={this.dialogVisible}
          on-on-visible-change={this.onDialogVisibleChange}
        >
          <img class={this.ns.be('modal', 'img')} src={this.dialogImageUrl} />
        </i-modal>
      </div>
    );
  },
});
