var F = Object.defineProperty;
var I = (l, d, e) => d in l ? F(l, d, { enumerable: !0, configurable: !0, writable: !0, value: e }) : l[d] = e;
var O = (l, d, e) => (I(l, typeof d != "symbol" ? d + "" : d, e), e);
import { defineComponent as T, getCurrentInstance as N, h as A } from "vue";
import { useControlController as z, useNamespace as M } from "@ibiz-template/vue-util";
import { ChartModel as D } from "@ibiz-template/model";
import { Neuron as j, ControlNerve as $, ControlController as q } from "@ibiz-template/controller";
import { createUUID as R } from "qx-util";
import { init as V } from "echarts";
import { mergeDeepRight as y } from "ramda";
import { ControlService as B } from "@ibiz-template/service";
class U extends j {
}
class X extends $ {
  createNeuron() {
    return new U(this.bindAbility());
  }
  bindAbility() {
    return {
      ...super.bindAbility(),
      load: this.controller.load.bind(this.controller)
    };
  }
}
function x(l) {
  const d = {};
  return l && Object.keys(l).forEach((e) => {
    const s = e.indexOf(".");
    if (s === -1)
      return;
    const r = e.slice(s + 1);
    r && l[e] !== void 0 && (d[r] = JSON.parse(l[e]));
  }), d;
}
function Y(l) {
  var e;
  const d = {};
  if (l) {
    d.show = l.showTitle, d.text = l.title, d.subtext = l.subTitle;
    const s = (e = l.titlePos) == null ? void 0 : e.toLowerCase();
    s === "left" || s === "right" ? d.left = s : (s === "bottom" || s === "top") && (d.left = "center", d.top = s);
  }
  return d;
}
function _(l) {
  var e;
  const d = {};
  if (l) {
    d.show = l.showLegend;
    const s = (e = l.legendPos) == null ? void 0 : e.toLowerCase();
    s === "left" || s === "right" ? (d.left = s, d.top = "middle", d.orient = "vertical") : s === "bottom" && (d.top = s);
  }
  return d;
}
function P(l) {
  return {
    axisLabel: {
      formatter: (e) => l === 1 ? e.length > 4 ? `${e.slice(0, 4).split("").join(`
`)}
...` : e.split("").join(`
`) : l === 2 && e.length > 4 ? `${e.slice(0, 4)}...` : e,
      rotate: l === 2 ? 45 : 0
    }
  };
}
function J(l) {
  const d = [];
  return l && l.length && l.forEach((e) => {
    const { caption: s, minValue: r, maxValue: o, eChartsType: t, position: i } = e, n = {
      name: s,
      min: r,
      max: o
    };
    Object.assign(n, {
      type: t,
      position: i,
      ...y(
        P(e.dataShowMode),
        x(e.userParams)
      )
    }), d.push(n);
  }), d;
}
function K(l) {
  const d = [];
  return l && l.length && l.forEach((e) => {
    const { caption: s, minValue: r, maxValue: o, eChartsType: t, position: i } = e, n = {
      name: s,
      min: r,
      max: o
    };
    Object.assign(n, {
      type: t,
      position: i,
      ...y(
        P(e.dataShowMode),
        x(e.userParams)
      )
    }), d.push(n);
  }), d;
}
class W extends B {
  constructor(e) {
    super(e);
    /**
     * 序列列表
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:38
     * @type {IPSDEChartSeries[]}
     */
    O(this, "seriesList", []);
    const s = e.source.getPSDEChartSerieses();
    if (!s || !s.length)
      throw new Error("图表序列集合不能为空");
    this.seriesList = s;
  }
  /**
   * 获取数据
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:11
   * @param {IContext} context
   * @param {IParams} [params={}]
   * @return {*}  {Promise<IHttpResponse>}
   */
  async fetch(e, s = {}) {
    return await this.exec(this.model.fetchAction, e, s);
  }
  /**
   * 获取所有代码表映射
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:21
   * @param {IContext} context
   * @param {IParams} params
   * @return {*}
   */
  async getAllCodeListMap(e, s) {
    const r = [];
    return await Promise.all(
      this.seriesList.map(async (o, t) => {
        var a, c, p, g;
        const i = {}, n = (c = (a = o.getCatalogPSCodeList) == null ? void 0 : a.call(o)) == null ? void 0 : c.codeName, C = (g = (p = o.getSeriesPSCodeList) == null ? void 0 : p.call(o)) == null ? void 0 : g.codeName;
        if (n) {
          const u = await ibiz.codeListService.get(
            n,
            e,
            s
          );
          if (u) {
            const f = /* @__PURE__ */ new Map();
            u.forEach((h) => {
              f.set(h.value, h.text);
            }), i.catalog = f;
          }
        }
        if (C) {
          const u = await ibiz.codeListService.get(
            C,
            e,
            s
          );
          if (u) {
            const f = /* @__PURE__ */ new Map();
            u.forEach((h) => {
              f.set(h.value, h.text);
            }), i.series = f;
          }
        }
        r[t] = i;
      })
    ), r;
  }
  /**
   * 生成数据集配置
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:37
   * @param {IPSDEChartSeries} series
   * @param {IData[]} data
   * @param {CodeListMap} map
   * @return {*}
   */
  generateDatasetOption(e, s, r) {
    var a;
    const o = {}, t = [];
    o.source = t;
    const i = e.catalogField.toLowerCase(), n = e.valueField.toLowerCase(), C = (a = e.seriesField) == null ? void 0 : a.toLowerCase();
    if (C) {
      const c = /* @__PURE__ */ new Set();
      s.forEach((p) => {
        c.add(p[C]);
      }), t.push([i, ...c]);
    } else
      t.push([i, n]);
    t.push(
      ...s.map((c) => t[0].map((p, g) => g === 0 ? (r && r.catalog ? r.catalog.get(c[p]) : c[p]) || "未定义" : C ? p === c[C] && c[n] || 0 : c[n] || 0))
    ), r && r.series && (t[0] = t[0].map((c, p) => {
      var g;
      return p === 0 ? c : ((g = r.series) == null ? void 0 : g.get(c)) || c;
    }));
    for (let c = 1; c < t.length; c++)
      for (let p = c + 1; p < t.length; p++)
        t[p][0] === t[c][0] && (t[p].forEach((g, u) => {
          u !== 0 && (t[c][u] += g);
        }), t.splice(p, 1), p -= 1);
    return o;
  }
  /**
   * 生成图表配置
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:49
   * @param {IData[]} data
   * @param {IContext} context
   * @param {IParams} params
   * @return {*}
   */
  async generateChartOption(e, s, r) {
    const o = {};
    o.dataset = [], o.series = [];
    const t = await this.getAllCodeListMap(s, r);
    return this.seriesList.forEach((i, n) => {
      if (i.eChartsType === "radar") {
        const { series: a, radar: c } = this.generateRadarSeriesOption(
          i,
          e,
          t[n]
        );
        Array.isArray(o.series) && o.series.push(...a), o.radar = c;
        return;
      }
      const C = this.generateDatasetOption(i, e, t[n]);
      if (Array.isArray(o.dataset) && o.dataset.push(C), i.eChartsType === "bar") {
        const a = this.generateBarSeriesOption(
          i,
          e,
          t[n],
          n
        );
        Array.isArray(o.series) && o.series.push(...a);
      } else if (i.eChartsType === "line") {
        const a = this.generateLineSeriesOption(
          i,
          e,
          t[n],
          n
        );
        Array.isArray(o.series) && o.series.push(...a);
      } else if (i.eChartsType === "pie") {
        const a = this.generatePieSeriesOption(
          i,
          e,
          t[n],
          n
        );
        Array.isArray(o.series) && o.series.push(...a);
      } else if (i.eChartsType === "funnel") {
        const a = this.generateFunnelSeriesOption(
          i,
          e,
          t[n],
          n
        );
        Array.isArray(o.series) && o.series.push(...a);
      } else if (i.eChartsType === "scatter") {
        const a = this.generateScatterSeriesOption(
          i,
          e,
          t[n],
          n
        );
        Array.isArray(o.series) && o.series.push(...a);
      } else
        throw new Error(`${i.eChartsType}类型的图表暂未实现`);
    }), o;
  }
  /**
   * 生成柱状图序列配置
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:13
   * @param {IPSDEChartSeries} series
   * @param {IData[]} data
   * @param {CodeListMap} map
   * @param {number} index
   * @return {*}
   */
  generateBarSeriesOption(e, s, r, o) {
    var u, f, h, m, w, S, b;
    const t = [], i = e.eChartsType, n = e.catalogField.toLowerCase(), C = e.valueField.toLowerCase(), a = (u = e.seriesField) == null ? void 0 : u.toLowerCase(), c = +((m = (h = (f = e.M) == null ? void 0 : f.getPSChartSeriesEncode) == null ? void 0 : h.getPSChartXAxis) == null ? void 0 : m.id) || 0, p = +((b = (S = (w = e.M) == null ? void 0 : w.getPSChartSeriesEncode) == null ? void 0 : S.getPSChartYAxis) == null ? void 0 : b.id) || 0, g = {};
    if (a) {
      const E = /* @__PURE__ */ new Set();
      s.forEach((L) => {
        const v = L[a];
        E.add(r && r.series && r.series.get(v) || v);
      }), t.push(
        ...[...E].map((L) => ({
          type: i,
          xAxisIndex: c,
          yAxisIndex: p,
          name: L,
          datasetIndex: o,
          encode: {
            x: n,
            y: L
          },
          ...y(
            g,
            x(e.userParams)
          )
        }))
      );
    } else
      t.push({
        type: i,
        xAxisIndex: c,
        yAxisIndex: p,
        name: e.caption || e.id,
        datasetIndex: o,
        encode: {
          x: n,
          y: C
        },
        ...y(
          g,
          x(e.userParams)
        )
      });
    return t;
  }
  /**
   * 生成折线图序列配置
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:32
   * @param {IPSDEChartSeries} series
   * @param {IData[]} data
   * @param {CodeListMap} map
   * @param {number} index
   * @return {*}
   */
  generateLineSeriesOption(e, s, r, o) {
    var u, f, h, m, w, S, b;
    const t = [], i = e.eChartsType, n = e.catalogField.toLowerCase(), C = e.valueField.toLowerCase(), a = (u = e.seriesField) == null ? void 0 : u.toLowerCase(), c = +((m = (h = (f = e.M) == null ? void 0 : f.getPSChartSeriesEncode) == null ? void 0 : h.getPSChartXAxis) == null ? void 0 : m.id) || 0, p = +((b = (S = (w = e.M) == null ? void 0 : w.getPSChartSeriesEncode) == null ? void 0 : S.getPSChartYAxis) == null ? void 0 : b.id) || 0, g = {
      emphasis: {
        label: {
          fontSize: 20,
          show: !0
        }
      },
      label: {
        position: "top",
        show: !0
      }
    };
    if (a) {
      const E = /* @__PURE__ */ new Set();
      s.forEach((L) => {
        const v = L[a];
        E.add(r && r.series && r.series.get(v) || v);
      }), t.push(
        ...[...E].map((L) => ({
          type: i,
          xAxisIndex: c,
          yAxisIndex: p,
          name: L,
          datasetIndex: o,
          encode: {
            x: n,
            y: L
          },
          stack: e.M.stack ? e.id : void 0,
          step: e.M.step ? "middle" : !1,
          ...y(
            g,
            x(e.userParams)
          )
        }))
      );
    } else
      t.push({
        type: i,
        xAxisIndex: c,
        yAxisIndex: p,
        name: e.caption || e.id,
        datasetIndex: o,
        encode: {
          x: n,
          y: C
        },
        ...y(
          g,
          x(e.userParams)
        )
      });
    return t;
  }
  /**
   * 生成饼图序列配置
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:44
   * @param {IPSDEChartSeries} series
   * @param {IData[]} data
   * @param {CodeListMap} map
   * @param {number} index
   * @return {*}
   */
  generatePieSeriesOption(e, s, r, o) {
    var p;
    const t = [], i = e.eChartsType, n = e.catalogField.toLowerCase(), C = e.valueField.toLowerCase(), a = (p = e.seriesField) == null ? void 0 : p.toLowerCase(), c = {
      emphasis: {
        label: {
          fontSize: 20,
          show: !0
        }
      },
      label: {
        formatter: "{b}: {d}%({@age})",
        position: "outside",
        show: !0
      }
    };
    if (a) {
      const g = /* @__PURE__ */ new Set();
      s.forEach((u) => {
        const f = u[a];
        g.add(r && r.series && r.series.get(f) || f);
      }), t.push(
        ...[...g].map((u) => ({
          type: i,
          name: u,
          datasetIndex: o,
          encode: {
            itemName: n,
            value: u
          },
          ...y(
            c,
            x(e.userParams)
          )
        }))
      );
    } else
      t.push({
        type: i,
        name: e.caption || e.id,
        datasetIndex: o,
        encode: {
          itemName: n,
          value: C
        },
        ...y(
          c,
          x(e.userParams)
        )
      });
    return t;
  }
  /**
   * 生成漏斗图序列配置
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:03
   * @param {IPSDEChartSeries} series
   * @param {IData[]} data
   * @param {CodeListMap} map
   * @param {number} index
   * @return {*}
   */
  generateFunnelSeriesOption(e, s, r, o) {
    var p;
    const t = [], i = e.eChartsType, n = e.catalogField.toLowerCase(), C = e.valueField.toLowerCase(), a = (p = e.seriesField) == null ? void 0 : p.toLowerCase(), c = {
      emphasis: {
        label: {
          fontSize: 20,
          show: !0
        }
      },
      label: {
        formatter: "{b}: {d}%({@age})",
        position: "outside",
        show: !0
      }
    };
    if (a) {
      const g = /* @__PURE__ */ new Set();
      s.forEach((u) => {
        const f = u[a];
        g.add(r && r.series && r.series.get(f) || f);
      }), t.push(
        ...[...g].map((u) => ({
          type: i,
          name: u,
          datasetIndex: o,
          encode: {
            itemName: n,
            value: u
          },
          ...y(
            c,
            x(e.userParams)
          )
        }))
      );
    } else
      t.push({
        type: i,
        name: e.caption || e.id,
        datasetIndex: o,
        encode: {
          itemName: n,
          value: C
        },
        ...y(
          c,
          x(e.userParams)
        )
      });
    return t;
  }
  /**
   * 生成散点图序列配置
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:25
   * @param {IPSDEChartSeries} series
   * @param {IData[]} data
   * @param {CodeListMap} map
   * @param {number} index
   * @return {*}
   */
  generateScatterSeriesOption(e, s, r, o) {
    var p;
    const t = [], i = e.eChartsType, n = e.catalogField.toLowerCase(), C = e.valueField.toLowerCase(), a = (p = e.seriesField) == null ? void 0 : p.toLowerCase(), c = {
      emphasis: {
        label: {
          fontSize: 20,
          show: !0
        }
      },
      label: {
        position: "top",
        show: !0
      }
    };
    if (a) {
      const g = /* @__PURE__ */ new Set();
      s.forEach((u) => {
        const f = u[a];
        g.add(r && r.series && r.series.get(f) || f);
      }), t.push(
        ...[...g].map((u) => ({
          type: i,
          name: u,
          datasetIndex: o,
          encode: {
            x: n,
            y: u
          },
          ...y(
            c,
            x(e.userParams)
          )
        }))
      );
    } else
      t.push({
        type: i,
        name: e.caption || e.id,
        datasetIndex: o,
        encode: {
          x: n,
          y: C
        },
        ...y(
          c,
          x(e.userParams)
        )
      });
    return t;
  }
  /**
   * 生成雷达图序列配置
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:47
   * @param {IPSDEChartSeries} series
   * @param {IData[]} data
   * @param {CodeListMap} map
   * @return {*}
   */
  generateRadarSeriesOption(e, s, r) {
    var f;
    const o = [], t = [], i = e.eChartsType, n = e.catalogField.toLowerCase(), C = e.valueField.toLowerCase(), a = (f = e.seriesField) == null ? void 0 : f.toLowerCase(), c = {
      emphasis: {
        label: {
          fontSize: 20,
          show: !0
        }
      },
      label: {
        position: "top",
        show: !0
      }
    };
    if (a) {
      const h = /* @__PURE__ */ new Set();
      s.forEach((m) => {
        h.add(m[a]);
      }), t.push([n, ...h]);
    } else
      t.push([n, C]);
    t.push(
      ...s.map((h) => t[0].map((m, w) => w === 0 ? (r && r.catalog ? r.catalog.get(h[m]) : h[m]) || "未定义" : a ? m === h[a] ? h[C] : 0 : h[C]))
    ), r && r.series && (t[0] = t[0].map((h, m) => {
      var w;
      return m === 0 ? h : ((w = r.series) == null ? void 0 : w.get(h)) || h;
    }));
    for (let h = 1; h < t.length; h++)
      for (let m = h + 1; m < t.length; m++)
        t[m][0] === t[h][0] && (t[m].forEach((w, S) => {
          S !== 0 && (t[h][S] += w);
        }), t.splice(m, 1), m -= 1);
    const p = t[0].slice(1).map((h, m) => t.slice(1).map((w) => w[m + 1]));
    o.push({
      type: i,
      name: e.caption || e.id,
      data: p,
      ...y(c, x(e.userParams))
    });
    let g = -1 / 0;
    p.forEach((h) => {
      h.forEach((m) => {
        +m > g && (g = +m);
      });
    });
    const u = t.slice(1).map((h) => ({
      name: h[0],
      max: g
    }));
    return {
      series: o,
      radar: {
        indicator: u
      }
    };
  }
}
class G extends q {
  constructor() {
    super(...arguments);
    /**
     * 图表实例
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:45
     * @type {(EChartsType | null)}
     */
    O(this, "chart", null);
    /**
     * 图表id
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:22
     * @type {string}
     */
    O(this, "chartId", `chart_${R()}`);
    /**
     * 图表静态配置
     *
     * @author zhanghengfeng
     * @date 2023-04-03 16:04:32
     * @type {EChartsOption}
     */
    O(this, "chartStaticOption", {});
    /**
     * 数据集合
     *
     * @author zhanghengfeng
     * @date 2023-04-07 16:04:34
     * @type {IData[]}
     */
    O(this, "items", []);
    /**
     * 请求参数
     *
     * @author zhanghengfeng
     * @date 2023-04-07 16:04:28
     */
    O(this, "queryParams", {
      page: 0,
      size: 1e3,
      query: ""
    });
    /**
     * 图表部件宽度
     *
     * @author zhanghengfeng
     * @date 2023-04-11 15:04:23
     * @type {string}
     */
    O(this, "width", "100%");
    /**
     * 图表部件高度
     *
     * @author zhanghengfeng
     * @date 2023-04-11 15:04:37
     * @type {string}
     */
    O(this, "height", "100%");
  }
  /**
   * 创建图表神经系统
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:24
   * @protected
   * @return {*}  {ChartNerve}
   */
  createNerve() {
    return new X(this);
  }
  /**
   * 初始化配置
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:41
   * @protected
   * @return {*}  {Promise<void>}
   */
  async onInit() {
    await super.onInit(), this.service = new W(this.model), await this.service.init(this.context), this.initChartStaticOption(), this.resizeChart = this.resizeChart.bind(this), window.addEventListener("resize", this.resizeChart);
    const { width: e, height: s } = this.model.source;
    e && (this.width = `${e}px`), s && (this.height = `${s}px`);
  }
  /**
   * 重新渲染图表
   *
   * @author zhanghengfeng
   * @date 2023-04-03 18:04:35
   */
  resizeChart() {
    var e;
    (e = this.chart) == null || e.resize();
  }
  /**
   * 初始化图表静态配置
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:52
   */
  initChartStaticOption() {
    const e = {}, s = this.model.source.getPSDEChartTitle();
    e.title = s ? Y(s) : {}, e.tooltip = {
      show: !0
    };
    const r = this.model.source.getPSDEChartSerieses();
    r && r.length && r[0].eChartsType === "bar" && (e.tooltip = {
      show: !0,
      padding: 0,
      backgroundColor: "rgba(255, 255, 255, 0)",
      borderWidth: 0,
      className: "chart-tooltip",
      borderRadius: 6,
      extraCssText: "box-shadow: none;",
      trigger: "axis",
      axisPointer: {
        type: "shadow"
      },
      appendToBody: !0,
      formatter: (n) => {
        const C = n, a = document.createElement("div");
        if (a.classList.add("chart-tooltip-container"), Array.isArray(n)) {
          const c = [], p = /* @__PURE__ */ new Map();
          C.forEach((u) => {
            const f = u.seriesName, h = u.dimensionNames;
            h.slice(1).forEach((m, w) => {
              const S = h.length === 2 ? f : m, b = u.value[w + 1];
              p.has(S) || (c.push({
                x: S,
                y: b
              }), p.set(S, b));
            });
          });
          const g = document.createElement("div");
          return g.classList.add("chart-tooltip-title"), g.textContent = C[0].value[0], a.appendChild(g), c.forEach((u) => {
            const f = document.createElement("div");
            f.classList.add("chart-tooltip-item");
            const h = document.createElement("div");
            h.classList.add("chart-tooltip-item-name"), h.textContent = u.x, f.appendChild(h);
            const m = document.createElement("div");
            m.classList.add("chart-tooltip-item-number"), m.textContent = u.y, f.appendChild(m), a.appendChild(f);
          }), a;
        }
        return a;
      }
    });
    const o = this.model.source.getPSDEChartLegend();
    e.legend = o ? _(o) : {};
    const t = this.model.source.getPSChartXAxises();
    e.xAxis = t ? J(t) : [];
    const i = this.model.source.getPSChartYAxises();
    e.yAxis = i ? K(i) : [], Object.assign(
      this.chartStaticOption,
      y(e, x(this.model.source.userParams))
    );
  }
  /**
   * 加载数据
   *
   * @author zhanghengfeng
   * @date 2023-04-03 16:04:13
   * @param {IParams} params
   */
  async load() {
    var e;
    await this.startLoading();
    try {
      const { data: s } = await this.service.fetch(this.context, {
        ...this.params,
        ...this.queryParams
      });
      if (Array.isArray(s) && s.length) {
        if (this.items = s, !this.chart) {
          const o = document.querySelector(`#${this.chartId}`);
          if (!o)
            throw new Error("未找到ECharts绘制容器元素");
          this.chart = V(o);
        }
        const r = await this.service.generateChartOption(
          s,
          this.context,
          this.params
        );
        this.chart.setOption({
          ...this.chartStaticOption,
          ...r
        });
      } else
        this.items = [], (e = this.chart) == null || e.clear();
    } finally {
      await this.endLoading();
    }
  }
  destroy() {
    var e;
    super.destroy(), (e = this.chart) == null || e.dispose(), window.removeEventListener("resize", this.resizeChart);
  }
}
function H(l, d, e, s = {}) {
  return z(l, () => new G(d, e, s));
}
const ie = T({
  name: "ChartControl",
  props: {
    modelData: {
      type: D,
      required: !0
    },
    context: {
      type: Object,
      required: !0
    },
    params: {
      type: Object,
      default: () => ({})
    }
  },
  setup(l) {
    const {
      proxy: d
    } = N(), e = M("chart");
    return {
      c: H(d, l.modelData, l.context, l.params),
      ns: e
    };
  },
  render() {
    if (this.c.complete)
      return A("control-layout", {
        attrs: {
          modelData: this.c.model
        }
      }, [A("div", {
        class: this.ns.b(),
        style: {
          width: this.c.width,
          height: this.c.height
        }
      }, [A("div", {
        attrs: {
          id: this.c.chartId
        },
        class: this.ns.b("content")
      }), this.c.items.length ? null : A("div", {
        class: this.ns.b("empty-content")
      }, ["暂无数据"])])]);
  }
});
export {
  ie as default
};
