import { ListController } from '@ibiz-template/controller';
import { ControlVO } from '@ibiz-template/service';
/**
 * 使用列表
 *
 * @export
 * @param {ListController} c
 * @returns {*}
 */
export function useListEvent(c: ListController) {
  // 处理单击
  const handleClick = (data: ControlVO) => {
    const selectIndex = c.selectedData.findIndex(selectData => {
      return data.srfkey === selectData.srfkey;
    });
    if (!c.singleSelect) {
      // 多选
      const selections = c.selectedData;
      // 没有加入，有就删除
      if (selectIndex === -1) {
        selections.push(data);
      } else {
        selections.splice(selectIndex, 1);
      }
      c.onSelectionChange(selections);
    } else if (selectIndex === -1) {
      // 单选,没有就放这一条，有就清空
      c.onSelectionChange([data]);
    } else {
      c.onSelectionChange([]);
    }
    c.handleClick(data);
  };

  // 处理双击
  const handleDblClick = (data: ControlVO) => {
    c.handleDblClick(data);
  };
  return { handleClick, handleDblClick };
}
