import { MDViewController, ViewController } from '@ibiz-template/controller';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent, PropType } from 'vue';
import '@ibiz-template/theme/style/components/layout/view-base/view-base.scss';

export const ViewBase = defineComponent({
  props: {
    controller: {
      type: Object as PropType<ViewController>,
      required: true,
    },
  },
  setup() {
    const ns = useNamespace('view');

    return { ns };
  },
  render() {
    const c = this.controller;

    // 外面的插槽同样传给view-layout
    const inheritSlots: IData = {};
    Object.keys(this.$scopedSlots).forEach(key => {
      inheritSlots[key] = (arg: IData) => this.$scopedSlots[key]!(arg);
    });

    return (
      <view-layout
        class={[
          this.ns.b(),
          c.complete && this.ns.b(this.controller.model.typeClass),
        ]}
        isComplete={c.complete}
        modelData={c.model}
        viewMode={c.modal.mode}
        isLoading={c.viewLoading.isLoading}
        scopedSlots={{
          caption: () => {
            return (
              <div class={this.ns.b('caption')}>
                {c.complete && c.model.source.getPSSysImage() ? (
                  [
                    <app-icon
                      class={this.ns.be('caption', 'icon')}
                      icon={c.model.source.getPSSysImage()}
                    ></app-icon>,
                    <span
                      class={this.ns.be('caption', 'text')}
                      title={c.caption}
                    >
                      {c.caption}
                    </span>,
                  ]
                ) : (
                  <span class={this.ns.be('caption', 'text')} title={c.caption}>
                    {c.caption}
                  </span>
                )}
              </div>
            );
          },
          toolbar: () => {
            if (c.complete && c.model.toolbar) {
              return [
                <view-toolbar
                  modelData={c.model.toolbar}
                  on-neuronInit={c.nerve.onNeuronInit(
                    c.model.toolbar.source.name,
                  )}
                  toolbarState={c.toolbarState}
                  viewMode={c.modal.mode}
                ></view-toolbar>,
              ];
            }
            return null;
          },
          quickSearch: () => {
            const _c = c as MDViewController;
            if (_c.complete && _c.model.source.enableQuickSearch) {
              return (
                <quick-search
                  value={_c.query}
                  viewMode={c.modal.mode}
                  placeholder={_c.model.placeholder}
                  on-update={(val: string) => {
                    _c.query = val;
                  }}
                  on-search={() => _c.onSearch()}
                ></quick-search>
              );
            }
          },
          searchForm: () => {
            const _c = c as MDViewController;
            if (_c.complete && _c.model.searchForm) {
              return (
                <search-form-control
                  modelData={_c.model.searchForm}
                  context={_c.context}
                  params={_c.params}
                  on-neuronInit={_c.nerve.onNeuronInit(
                    _c.model.searchForm.source.name,
                  )}
                ></search-form-control>
              );
            }
          },
          ...inheritSlots,
        }}
      />
    );
  },
});
