import { defineComponent } from 'vue';
import type { PropType } from 'vue';
import { useNamespace } from '@ibiz-template/vue-util';

export default defineComponent({
  props: {
    size: {
      type: String as PropType<'large' | 'medium' | 'small' | 'default'>,
      default: 'default',
    },
    active: Boolean,
  },
  setup(props) {
    const ns = useNamespace('skeleton-element');

    return () => (
      <div class={`${ns.b()} ${props.active ? ns.m('active') : ''}`.trim()}>
        <skeleton-element prefixClass='input' props={props}></skeleton-element>
      </div>
    );
  },
});
