import { Prop, Component } from 'vue-property-decorator';
import { IPSAppDETabExplorerView } from "@ibiz/dynamic-model-api";
import { AppDefaultViewLayout } from "../app-default-view-layout/app-default-view-layout";
import './app-default-tabexpview-layout.less';

@Component({})
export class AppDefaultTabExpViewLayout extends AppDefaultViewLayout {

    /**
     * 实体分页导航视图模型对象
     *
     * @type {IPSAppDETabExplorerView}
     * @memberof AppDefaultTabExpViewLayout
     */
    @Prop() public declare viewInstance: IPSAppDETabExplorerView;

    /**
     * 引擎初始化
     *
     * @param {*} [opts={}]
     * @memberof AppDefaultTabExpViewLayout
     */
    public engineInit(opts: any = {}) {
        let engineOpts = Object.assign({
            view: this,
            p2k: '0',
            isLoadDefault: this.viewInstance?.loadDefault,
            keyPSDEField: this.appDeCodeName.toLowerCase(),
            majorPSDEField: this.appDeMajorFieldName.toLowerCase()
        }, opts);
        this.engine.init(engineOpts);
    }

    /**
     * 绘制头部内容
     * 
     * @memberof AppDefaultTabExpViewLayout
     */
    public renderViewHeader() {
        const offset ={
            root: this.$parent,
            gap: 8,
            targetClass: 'ivu-tabs-bar',
        }
        return (
            <div slot="title" class='header-container' key='view-header'>
                {this.showCaption ? 
                    <div class="caption" v-tab-offset={offset}>
                        <span class='info'>{this.$slots.captionInfo ? this.$slots.captionInfo : this.viewInstance.caption}</span>
                    </div> : null }
            </div>
        )
    }
    
    /**
     * 绘制内容
     * 
     * @memberof AppDefaultTabExpViewLayout
     */
    public renderContent() {
        //TODO 分页位置样式等待模型补充
        let cardClass = {
            'view-card': true,
            'view-no-caption': !this.showCaption,
            'view-no-toolbar': !this.viewIsshowToolbar,
            'view-tabs-mode-default': true
        };
        return (
            <card class={cardClass} disHover={true} bordered={false}>
                {this.renderViewHeader()}
                {this.$slots.topMessage}
                {this.$slots.searchForm}
                <div class='content-container'>
                    { (this.$slots.quickGroupSearch || this.$slots.quickSearch) && <div style="margin-bottom: 6px;">
                        {this.$slots.quickGroupSearch}
                        {this.$slots.quickSearchForm}
                        {this.$slots.quickSearch}
                    </div> }
                    {this.$slots.bodyMessage}
                    {this.$slots.default}
                </div>
                {this.$slots.bottomMessage}
            </card>
        );
    }

}