import {
  useMPickupViewController,
  useNamespace,
} from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType, Ref, ref } from 'vue';
import { IModal } from '@ibiz-template/runtime';
import '@ibiz-template/theme/style/components/views/mpickup-view/mpickup-view.scss';

export const MPickupView = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams>, default: () => ({}) },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
    noLoadDefault: { type: Boolean, required: false },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;

    const c = useMPickupViewController(proxy, props.modelPath);

    // model.typeClass
    const ns = useNamespace('view-dempickupview');

    // UI层单击选中的数组
    const UISelections: Ref<IData[]> = ref([]);

    const handleSelectionClick = (selection: IData) => {
      const index = UISelections.value.indexOf(selection);
      if (index === -1) {
        UISelections.value.push(selection);
      } else {
        UISelections.value.splice(index, 1);
      }
    };

    const isSelected = (selection: IData) => {
      return UISelections.value.includes(selection);
    };

    const addRight = () => {
      c.addSelections(c.embedSelection);
      UISelections.value = [];
    };

    const addRightAll = () => {
      c.selectAll();
      UISelections.value = [];
    };

    const removeRight = () => {
      c.removeSelections(UISelections.value);
      UISelections.value = [];
    };
    const removeRightAll = () => {
      c.selfSelection = [];
      UISelections.value = [];
    };

    return {
      ns,
      c,
      addRight,
      addRightAll,
      removeRight,
      removeRightAll,
      handleSelectionClick,
      isSelected,
    };
  },
  render(h) {
    let panelComponent = null;
    if (this.c.complete) {
      const { pickupViewPanel } = this.c.model;
      if (this.c.providers[pickupViewPanel.name]) {
        panelComponent = h(this.c.providers[pickupViewPanel.name].component, {
          props: {
            modelData: pickupViewPanel,
            context: this.c.context,
            params: this.c.params,
            singleSelect: false,
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit(pickupViewPanel.name),
          },
        });
      }
    }
    return (
      <view-base
        class={this.ns.b()}
        controller={this.c}
        scopedSlots={{
          footer: () => {
            return (
              <div class={this.ns.b('footer')}>
                <i-button
                  on-click={() => {
                    this.c.onOkButtonClick();
                  }}
                >
                  确定
                </i-button>
                <i-button
                  on-click={() => {
                    this.c.onCancelButtonClick();
                  }}
                >
                  取消
                </i-button>
              </div>
            );
          },
        }}
      >
        <div class={this.ns.b('content')}>
          {this.c.complete && this.c.model.pickupViewPanel && (
            <div class={this.ns.b('left')}>{panelComponent}</div>
          )}
          <div class={this.ns.b('center')}>
            <i-button on-click={this.addRight} title='右移'>
              {'>'}
            </i-button>
            <i-button on-click={this.removeRight} title='左移'>
              {'<'}
            </i-button>
            <i-button on-click={this.addRightAll} title='全部右移'>
              {'>>'}
            </i-button>
            <i-button on-click={this.removeRightAll} title='全部左移'>
              {'<<'}
            </i-button>
          </div>
          <div class={this.ns.b('right')}>
            {this.c.selfSelection.map(item => {
              return (
                <div
                  key={item.srfkey}
                  class={[
                    this.ns.be('right', 'list-item'),
                    this.ns.is('selected', this.isSelected(item)),
                  ]}
                  on-click={() => this.handleSelectionClick(item)}
                >
                  <div
                    class={this.ns.bem('right', 'list-item', 'text')}
                    title={item.srfmajortext}
                  >
                    {item.srfmajortext}
                  </div>
                  <i-icon
                    type='ios-close'
                    size={24}
                    on-click={() => {
                      this.c.removeSelections([item]);
                    }}
                  />
                </div>
              );
            })}
          </div>
        </div>
      </view-base>
    );
  },
});
