import { FileUploaderEditorModel } from '@ibiz-template/model';
import {
  FormItemController,
  GridEditItemController,
  IEditorProvider,
  UploadEditorController,
} from '@ibiz-template/controller';
/**
 * 文件上传编辑器适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class FileUploaderEditorProvider
 * @implements {EditorProvider}
 */
export class FileUploaderEditorProvider
  implements IEditorProvider<UploadEditorController>
{
  formEditor: string = 'IBizFileUpload';

  rowEditor: string = 'IBizFileUpload';

  constructor(editorType: string) {
    if (editorType === 'PICTURE') {
      this.formEditor = 'AppImageUpload';
      this.rowEditor = 'AppImageUpload';
    } else if (editorType === 'FILEUPLOADER') {
      this.formEditor = 'IBizFileUpload';
      this.rowEditor = 'AppFileUploadRowPreview';
    }
  }

  async createController(
    editorModel: FileUploaderEditorModel,
    parentController: FormItemController | GridEditItemController,
  ): Promise<UploadEditorController> {
    const c = new UploadEditorController(editorModel, parentController);
    await c.init();
    return c;
  }
}
