import { CheckBoxListModel } from '@ibiz-template/model';
import {
  CheckBoxListEditorController,
  FormItemController,
  GridEditItemController,
  IEditorProvider,
} from '@ibiz-template/controller';
/**
 * 多选框列表编辑器适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class CheckBoxListEditorProvider
 * @implements {EditorProvider}
 */
export class CheckBoxListEditorProvider
  implements IEditorProvider<CheckBoxListEditorController>
{
  formEditor: string = 'IBizCheckBoxList';

  rowEditor: string = 'IBizCheckBoxList';

  async createController(
    editorModel: CheckBoxListModel,
    parentController: FormItemController | GridEditItemController,
  ): Promise<CheckBoxListEditorController> {
    const c = new CheckBoxListEditorController(editorModel, parentController);
    await c.init();
    return c;
  }
}
