import { DatePickerEditorModel } from '@ibiz-template/model';
import {
  DatePickerEditorController,
  FormItemController,
  GridEditItemController,
  IEditorProvider,
} from '@ibiz-template/controller';

/**
 * 日期时间选择器编辑器适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class DatePickerEditorProvider
 * @implements {EditorProvider}
 */
export class DatePickerEditorProvider implements IEditorProvider {
  formEditor: string = 'IBizDatePicker';

  gridEditor: string = 'IBizGridDatePicker';

  async createController(
    editorModel: DatePickerEditorModel,
    parentController: FormItemController | GridEditItemController,
  ): Promise<DatePickerEditorController> {
    const c = new DatePickerEditorController(editorModel, parentController);
    await c.init();
    return c;
  }
}
