import { useNamespace } from '@ibiz-template/vue-util';
import { computed, defineComponent } from 'vue';
import '@ibiz-template/theme/style/components/widgets/grid/grid-editor.scss';

export const GridEditor = defineComponent({
  name: 'GridEditor',
  props: {
    disabled: {
      type: Boolean,
    },
    readonly: {
      type: Boolean,
    },
  },
  setup(props) {
    const ns = useNamespace('grid-editor');
    const editable = computed(() => {
      return !props.disabled && !props.readonly;
    });
    return { ns, editable };
  },
  render() {
    return (
      <div
        class={[this.ns.b(), this.editable ? this.ns.m('editable') : '']}
        onDblclick={evt => evt.stopPropagation()}
        onClick={evt => evt.stopPropagation()}
      >
        {this.$slots.default}
      </div>
    );
  },
});
export default GridEditor;
