var ce = Object.defineProperty;
var de = (e, t, s) => t in e ? ce(e, t, { enumerable: !0, configurable: !0, writable: !0, value: s }) : e[t] = s;
var P = (e, t, s) => (de(e, typeof t != "symbol" ? t + "" : t, s), s);
import { IndexViewModel as ue, GridModel as he, ViewType as me, ModelUtil as pe } from "@ibiz-template/model";
import { GridFieldColumnController as X, GridRowController as J, WFStepTraceViewController as fe, UploadEditorController as Q, GridController as ge, GridNotifyState as be, WFDynaEditView3Controller as ve } from "@ibiz-template/controller";
import { defineComponent as E, computed as D, h as c, getCurrentInstance as L, ref as f, watch as I, toRefs as B, onUnmounted as we } from "vue";
import { useNamespace as x, useViewController as K, usePropsWatch as z, getUploadProps as ye, getEditorEmits as Y, getGridUploadProps as _, getGridEditorEmits as $, useClickOutside as Ce, useEventListener as Fe, getInputProps as Se, getGridInputProps as Ue, useGridCellEditor as Ee, useControlController as ke, useWFStepTraceViewController as xe, useEditView3Controller as Pe } from "@ibiz-template/vue-util";
import { colorBlend as Ie, HttpError as Z, isImage as Ne, uploadFile as Te, RuntimeError as De } from "@ibiz-template/core";
import { getCookie as Re, createUUID as V } from "qx-util";
import { debounce as Le } from "lodash-es";
import { ViewMode as ee, UIActionHandler as te, PluginStaticResource as Ae } from "@ibiz-template/runtime";
const Ge = E({
  name: "CodeListGridColumn",
  props: {
    controller: {
      type: X,
      required: !0
    },
    row: {
      type: J,
      required: !0
    }
  },
  setup(e) {
    const t = x("grid-field-column"), s = D(() => {
      var r;
      if (e.controller.model.source.cLConvertMode !== "FRONT")
        return [];
      const n = e.row.data[e.controller.model.codeName];
      return (r = e.controller.codeListItems) != null && r.length && n ? n.split(",").map((h) => {
        const p = e.controller.codeListItems.find((g) => g.value === h);
        if (p) {
          const g = p.color || "#515a6e";
          return {
            text: p.text,
            colorStyle: t.cssVarBlock({
              color: g,
              "border-color": g,
              "bg-color": Ie(g, "#fff")
            })
          };
        }
      }).filter(Boolean) : [];
    }), o = (n) => {
      e.controller.isLinkColumn && e.controller.openLinkView(e.row, n);
    }, i = D(() => {
      let n = "";
      switch (e.controller.model.align) {
        case "LEFT":
          n = "flex-start";
          break;
        case "RIGHT":
          n = "flex-end";
          break;
        default:
          n = "center";
          break;
      }
      return t.cssVarBlock({
        "justify-content": n
      });
    });
    return {
      ns: t,
      alignStyle: i,
      selectedItems: s,
      onCellClick: o
    };
  },
  render() {
    const e = this.controller, t = this.row.data[e.model.codeName];
    return c("div", {
      class: [this.ns.b(), e.isLinkColumn && this.ns.m("link-column")],
      style: this.alignStyle,
      on: {
        click: this.onCellClick
      }
    }, [this.selectedItems.length > 0 ? this.selectedItems.map((s) => c("span", {
      class: this.ns.e("code-list-item"),
      style: s.colorStyle
    }, [s.text])) : c("span", {
      class: this.ns.e("text")
    }, [t])]);
  }
});
class Oe extends fe {
  constructor() {
    super(...arguments);
    /**
     * 流程图url
     *
     * @type {string}
     * @memberof PresetWFChartViewController
     */
    P(this, "imgSrc");
  }
  async getUIData() {
    const s = Object.assign(this.context.clone(), this.params), o = await this.entityService.wf.getWFProcessDiagram(s), i = new Blob([o.data], {
      type: "image/svg+xml"
    });
    this.imgSrc = URL.createObjectURL(i);
  }
}
const Me = E({
  name: "PresetWFChartView",
  props: {
    context: Object,
    params: {
      type: Object
    },
    modelPath: {
      type: String,
      required: !0
    },
    modal: {
      type: Object
    },
    deName: {
      type: String,
      required: !0
    }
  },
  setup(e) {
    const t = x("preset-wf-chart-view"), {
      proxy: s
    } = L(), o = K(s, (i, n) => new Oe(e.modelPath, i, n));
    return z(s, "deName", o.setDeName.bind(o)), {
      c: o,
      ns: t
    };
  },
  render() {
    return c("div", {
      class: this.ns.b()
    }, [c("img", {
      attrs: {
        src: this.c.imgSrc
      }
    })]);
  }
});
const Be = E({
  name: "WFToolbar",
  props: {
    wfLinks: {
      type: Array,
      required: !0
    }
  },
  setup(e, {
    emit: t
  }) {
    return {
      ns: x("wf-toolbar"),
      handleClick: async (i, n) => {
        t("wf-link-click", i, n);
      }
    };
  },
  render() {
    const e = this.wfLinks || [];
    return c("div", {
      class: `${this.ns.b()}`
    }, [e.length > 0 && e.map((t) => {
      const s = t.sequenceFlowName == "驳回" || t.sequenceFlowName == "取消";
      return c("div", {
        key: t.sequenceFlowId,
        class: [this.ns.e("item"), s ? this.ns.em("item", "reject") : ""]
      }, [c("i-button", {
        attrs: {
          title: t.sequenceFlowName
        },
        on: {
          click: (o) => this.handleClick(t, o)
        }
      }, [t.sequenceFlowName || ""])]);
    })]);
  }
}), ze = typeof btoa == "function", j = typeof Buffer == "function";
typeof TextDecoder == "function" && new TextDecoder();
const W = typeof TextEncoder == "function" ? new TextEncoder() : void 0, _e = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=", R = Array.prototype.slice.call(_e);
((e) => {
  let t = {};
  return e.forEach((s, o) => t[s] = o), t;
})(R);
const N = String.fromCharCode.bind(String);
typeof Uint8Array.from == "function" && Uint8Array.from.bind(Uint8Array);
const $e = (e) => e.replace(/=/g, "").replace(/[+\/]/g, (t) => t == "+" ? "-" : "_"), je = (e) => {
  let t, s, o, i, n = "";
  const r = e.length % 3;
  for (let a = 0; a < e.length; ) {
    if ((s = e.charCodeAt(a++)) > 255 || (o = e.charCodeAt(a++)) > 255 || (i = e.charCodeAt(a++)) > 255)
      throw new TypeError("invalid character found");
    t = s << 16 | o << 8 | i, n += R[t >> 18 & 63] + R[t >> 12 & 63] + R[t >> 6 & 63] + R[t & 63];
  }
  return r ? n.slice(0, r - 3) + "===".substring(r) : n;
}, se = ze ? (e) => btoa(e) : j ? (e) => Buffer.from(e, "binary").toString("base64") : je, Ve = j ? (e) => Buffer.from(e).toString("base64") : (e) => {
  let s = [];
  for (let o = 0, i = e.length; o < i; o += 4096)
    s.push(N.apply(null, e.subarray(o, o + 4096)));
  return se(s.join(""));
}, We = (e) => {
  if (e.length < 2) {
    var t = e.charCodeAt(0);
    return t < 128 ? e : t < 2048 ? N(192 | t >>> 6) + N(128 | t & 63) : N(224 | t >>> 12 & 15) + N(128 | t >>> 6 & 63) + N(128 | t & 63);
  } else {
    var t = 65536 + (e.charCodeAt(0) - 55296) * 1024 + (e.charCodeAt(1) - 56320);
    return N(240 | t >>> 18 & 7) + N(128 | t >>> 12 & 63) + N(128 | t >>> 6 & 63) + N(128 | t & 63);
  }
}, qe = /[\uD800-\uDBFF][\uDC00-\uDFFFF]|[^\x00-\x7F]/g, He = (e) => e.replace(qe, We), q = j ? (e) => Buffer.from(e, "utf8").toString("base64") : W ? (e) => Ve(W.encode(e)) : (e) => se(He(e)), oe = (e, t = !1) => t ? $e(q(e)) : q(e);
function Xe(e, t, s) {
  var S;
  const o = f([]), i = f({
    Authorization: `Bearer ${Re("access_token")}`
  }), n = f(""), r = f(""), a = {
    count: 0,
    cacheFiles: []
    // iview上传过程中不能改default-file-list,所以需要缓存
  }, d = (S = s.editorParams) == null ? void 0 : S.blackList;
  let h = [];
  d && typeof d == "string" && (h = d.split(",")), I(
    () => e.value,
    (l) => {
      o.value = l ? JSON.parse(l) : [];
    },
    { immediate: !0 }
  ), I(
    () => e.data,
    (l) => {
      if (l) {
        const u = s.calcBaseUrl(l);
        n.value = u.uploadUrl, r.value = u.downloadUrl;
      }
    },
    { immediate: !0, deep: !0 }
  ), I(
    o,
    (l) => {
      l != null && l.length && r.value && l.forEach((u) => {
        u.url = u.url || r.value.replace("%fileId%", u.id);
      });
    },
    { immediate: !0 }
  ), I(
    r,
    (l) => {
      l && o.value.length && o.value.forEach((u) => {
        u.url = r.value.replace("%fileId%", u.id);
      });
    },
    { immediate: !0 }
  );
  const p = () => {
    const l = [...o.value, ...a.cacheFiles], u = l.length > 0 ? JSON.stringify(l.map((v) => ({ name: v.name, id: v.id }))) : null;
    a.cacheFiles = [], t(u);
  }, g = (l) => {
    const u = l.name.trim().toLowerCase();
    if (h.some((F) => u.endsWith(`.${F}`)))
      return ibiz.message.error(`不可上传 ${h.join("、")}类型的文件！`), !1;
    a.count += 1;
  }, U = (l) => {
    l && (a.cacheFiles.push({
      name: l.filename,
      id: l.fileid
    }), a.count -= 1, a.count === 0 && p());
  }, y = (l, u) => {
    throw a.count -= 1, new Z({
      response: { data: u, status: l.status }
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
    });
  }, C = (l) => {
    if (e.disabled)
      return;
    const u = o.value.findIndex((v) => v.id === l.id);
    u !== -1 && o.value.splice(u, 1), p();
  }, b = (l) => {
    const u = l.url || r.value.replace("%fileId%", l.id);
    s.fileDownload({ url: u, name: l.name });
  }, m = f(!1), w = f(""), T = f("");
  return {
    uploadUrl: n,
    downloadUrl: r,
    headers: i,
    files: o,
    onDownload: b,
    onError: y,
    onRemove: C,
    onSuccess: U,
    beforeUpload: g,
    showModal: m,
    modalTitle: w,
    iframeUrl: T,
    onModalCancel: () => {
      m.value = !1, w.value = "", T.value = "";
    },
    previewFile: (l) => {
      m.value = !0, w.value = l.name;
      const u = window.Environment.previewFileUrl;
      if (u) {
        const v = encodeURIComponent(
          oe(
            `${window.location.origin}${l.url}?fullfilename=${l.name}`
          )
        );
        T.value = `${u}/onlinePreview?url=${v}`;
      }
    }
  };
}
const Je = E({
  name: "SyFileUpload",
  props: ye(),
  emits: Y(),
  setup(e, {
    emit: t
  }) {
    const s = x("sy-file-upload"), o = e.controller, {
      uploadUrl: i,
      headers: n,
      files: r,
      onDownload: a,
      onError: d,
      onRemove: h,
      onSuccess: p,
      beforeUpload: g,
      showModal: U,
      modalTitle: y,
      iframeUrl: C,
      onModalCancel: b,
      previewFile: m
    } = Xe(e, (w) => {
      t("change", w);
    }, o);
    return {
      ns: s,
      c: o,
      uploadUrl: i,
      headers: n,
      files: r,
      onDownload: a,
      onError: d,
      onRemove: h,
      onSuccess: p,
      beforeUpload: g,
      showModal: U,
      modalTitle: y,
      iframeUrl: C,
      onModalCancel: b,
      previewFile: m
    };
  },
  render(e) {
    return e("div", {
      class: [this.ns.b(), this.disabled ? this.ns.m("disabled") : "", this.readonly ? this.ns.m("readonly") : ""]
    }, [e("IUpload", {
      ref: "fileUpload",
      props: {
        action: this.uploadUrl,
        headers: this.headers,
        disabled: this.disabled,
        "default-file-list": this.files,
        multiple: this.c.model.multiple,
        type: this.c.model.isDrag ? "drag" : "select",
        accept: this.c.model.accept,
        "before-upload": this.beforeUpload,
        "on-success": this.onSuccess,
        "on-error": this.onError,
        "on-remove": this.onRemove,
        "on-preview": this.onDownload,
        "show-upload-list": !1
      }
    }, [this.c.model.isDrag ? e("div", {
      class: this.ns.bm("box", "drag")
    }, [e("i-icon", {
      attrs: {
        type: "md-cloud-upload"
      }
    }), e("div", {
      class: this.ns.be("box", "title")
    }, [e("span", ["将文件拖到此处，或"]), e("span", ["点击上传"])])]) : e("i-button", {
      attrs: {
        icon: "ios-cloud-upload-outline"
      },
      class: this.ns.bm("box", "select")
    }, ["上传文件"])]), e("div", {
      class: this.ns.b("file-list")
    }, [this.files.map((t) => e("div", {
      class: this.ns.b("file-item"),
      key: t.id
    }, [e("div", {
      class: this.ns.b("file-item-right")
    }, [e("div", {
      class: this.ns.b("file-item-right-title"),
      on: {
        click: () => this.previewFile(t)
      }
    }, [t.name]), e("div", {
      class: this.ns.b("file-item-right-action")
    }, [e("i-icon", {
      attrs: {
        type: "md-download"
      },
      on: {
        click: () => this.onDownload(t)
      }
    }), e("i-icon", {
      attrs: {
        type: "md-eye"
      },
      on: {
        click: () => this.previewFile(t)
      }
    }), this.disabled || this.readonly ? null : e("i-icon", {
      attrs: {
        type: "md-close"
      },
      on: {
        click: () => this.onRemove(t)
      }
    })])])]))]), e("i-modal", {
      attrs: {
        value: this.showModal,
        title: this.modalTitle,
        "class-name": this.ns.b("modal"),
        width: "70%",
        transfer: !1,
        "footer-hide": !0
      },
      on: {
        "on-cancel": this.onModalCancel
      }
    }, [e("iframe", {
      class: this.ns.b("iframe"),
      attrs: {
        src: this.iframeUrl
      }
    })])]);
  }
});
function O(e, t) {
  if (e.url = t.replace("%fileId%", e.id), e.status || (e.status = "finished"), !e.fileName) {
    const s = e.name.lastIndexOf(".");
    e.fileName = e.name.substring(0, s), e.fileExt = e.name.substring(s), e.isImage = Ne(e.name);
  }
  return e;
}
function ie(e) {
  const t = f(""), s = f(""), o = f([]);
  return I(
    e.data,
    (i) => {
      if (i) {
        const n = e.controller.value.calcBaseUrl(i);
        t.value = n.uploadUrl, s.value = n.downloadUrl;
      }
    },
    { immediate: !0, deep: !0 }
  ), I(
    e.value,
    (i) => {
      o.value = i ? JSON.parse(i) : [], o.value.length && s.value && o.value.forEach((n) => {
        O(n, s.value);
      });
    },
    { immediate: !0 }
  ), I(
    s,
    (i) => {
      i && o.value.length && o.value.forEach((n) => {
        O(n, i);
      });
    },
    { immediate: !0 }
  ), {
    downloadUrl: s,
    uploadUrl: t,
    valueList: o
  };
}
function ne(e) {
  var k, S;
  const t = f("undo"), s = f([]), { downloadUrl: o, value: i, uploadUrl: n, controller: r } = e, a = (S = (k = r == null ? void 0 : r.value) == null ? void 0 : k.editorParams) == null ? void 0 : S.blackList;
  let d = [];
  a && typeof a == "string" && (d = a.split(",")), I(
    i,
    (l) => {
      l.length > 0 && (s.value = [], l.forEach((u) => {
        s.value.push(O(u, o.value));
      }));
    },
    {
      immediate: !0,
      deep: !0
    }
  );
  const h = (l, u) => {
    const v = [];
    return u.forEach((F, A) => {
      const G = F.name.trim().toLowerCase();
      if (d.some((le) => G.endsWith(`.${le}`))) {
        v.push(A);
        return;
      }
      s.value.push({
        name: F.name,
        status: F.status,
        percentage: F.percentage,
        id: F.uid,
        url: ""
      });
    }), v.length === u.length ? (ibiz.message.error(`不可上传 ${d.join("、")}类型的文件！`), !1) : (v.length && (v.forEach((F) => {
      l.splice(F, 1), u.splice(F, 1);
    }), ibiz.message.error(`不可上传 ${d.join("、")}类型的文件！`)), !0);
  }, p = (l) => {
    l.forEach((u) => {
      s.value.find((v) => v.id === u.uid ? (v.percentage = u.percentage, !0) : !1);
    });
  }, g = (l, u) => {
    l.forEach((v) => {
      s.value.find((F) => F.id === v.uid ? (F.status = v.status, F.id = u.data.fileid, F.name = u.data.filename, O(F, o.value), !0) : !1);
    });
  }, U = (l, u) => {
    var F;
    l.forEach((A) => {
      s.value.find((G) => G.id === A.uid ? (G.status = A.status, !0) : !1);
    });
    const v = new Z(u);
    ibiz.notification.error({
      title: (F = v.status) == null ? void 0 : F.toString(),
      desc: v.message,
      duration: 10
    });
  }, y = (l) => {
    s.value = s.value.filter((u) => u.status === "finished"), t.value = "done";
  }, C = () => {
    Te({
      multiple: e.multiple,
      accept: e.accept,
      uploadUrl: n.value,
      beforeUpload: h,
      progress: p,
      success: g,
      error: U,
      finish: y
    });
  }, b = f(!1), m = f(""), w = f("");
  return {
    selectFile: C,
    fileList: s,
    uploadState: t,
    showModal: b,
    modalTitle: m,
    iframeUrl: w,
    onModalCancel: () => {
      b.value = !1, m.value = "", w.value = "";
    },
    previewFile: (l) => {
      b.value = !0, m.value = l.name;
      const u = window.Environment.previewFileUrl;
      if (u) {
        const v = encodeURIComponent(
          oe(
            `${window.location.origin}${l.url}?fullfilename=${l.name}`
          )
        );
        w.value = `${u}/onlinePreview?url=${v}`;
      }
    }
  };
}
const Qe = E({
  name: "SyGridFileUpload",
  props: _(),
  setup(e) {
    const t = x("sy-grid-file-upload"), {
      value: s,
      data: o,
      controller: i
    } = B(e), {
      downloadUrl: n,
      uploadUrl: r,
      valueList: a
    } = ie({
      value: s,
      data: o,
      controller: i
    }), {
      fileList: d,
      showModal: h,
      modalTitle: p,
      iframeUrl: g,
      previewFile: U,
      onModalCancel: y
    } = ne({
      downloadUrl: n,
      uploadUrl: r,
      value: a
    });
    return {
      ns: t,
      fileList: d,
      showModal: h,
      modalTitle: p,
      iframeUrl: g,
      downloadFile: (b) => {
        e.controller.fileDownload(b);
      },
      previewFile: U,
      onModalCancel: y
    };
  },
  render() {
    return c("grid-editor", {
      attrs: {
        disabled: this.disabled,
        readonly: this.readonly
      },
      class: [this.ns.b(), this.disabled ? this.ns.m("disabled") : "", this.readonly ? this.ns.m("readonly") : ""]
    }, [c("div", {
      class: this.ns.b("file-list")
    }, [this.fileList.map((e) => c("div", {
      class: this.ns.b("file-item"),
      key: e.id
    }, [c("div", {
      class: this.ns.b("file-item-title"),
      on: {
        click: () => this.previewFile(e)
      }
    }, [e.name]), c("div", {
      class: this.ns.b("file-item-action")
    }, [c("i-icon", {
      attrs: {
        type: "md-download"
      },
      on: {
        click: () => this.downloadFile(e)
      }
    }), c("i-icon", {
      attrs: {
        type: "md-eye"
      },
      on: {
        click: () => this.previewFile(e)
      }
    })])]))]), c("i-modal", {
      attrs: {
        value: this.showModal,
        title: this.modalTitle,
        "class-name": this.ns.b("modal"),
        width: "70%",
        transfer: !1,
        "footer-hide": !0
      },
      on: {
        "on-cancel": this.onModalCancel
      }
    }, [c("iframe", {
      class: this.ns.b("iframe"),
      attrs: {
        src: this.iframeUrl
      }
    })])]);
  }
}), Ke = E({
  name: "SyGridFileUploadContainer",
  props: _(),
  emits: $(),
  render(e) {
    return this.disabled || this.readonly ? e("SyGridFileUpload", {
      props: {
        ...this.$props
      }
    }) : e("SyEditGridFileUpload", {
      props: {
        ...this.$props
      },
      on: {
        change: (t, s) => {
          this.$emit("change", t, s);
        },
        rowSave: () => {
          this.$emit("rowSave");
        }
      }
    });
  }
});
const Ye = E({
  name: "SyEditGridFileUploadPopover",
  props: {
    uploadUrl: {
      type: String,
      required: !0
    },
    downloadUrl: {
      type: String,
      required: !0
    },
    value: {
      type: Array,
      required: !0
    },
    controller: {
      type: Q,
      required: !0
    }
  },
  emits: {
    close: (e) => !0
  },
  setup(e, {
    emit: t
  }) {
    const s = x("sy-edit-grid-file-upload-popover"), {
      downloadUrl: o,
      value: i,
      uploadUrl: n,
      controller: r
    } = B(e), {
      fileList: a,
      uploadState: d,
      selectFile: h
    } = ne({
      downloadUrl: o,
      value: i,
      uploadUrl: n,
      controller: r
    }), p = f(), g = f(!1), U = Ce(p, async (b) => {
      t("close", {
        isModified: g.value,
        resultFiles: a.value
      });
    });
    return I(d, (b) => {
      b === "done" ? (g.value = !0, U.proceed()) : b === "loading" && U.pause();
    }), {
      ns: s,
      componentRef: p,
      fileList: a,
      deleteFile: (b) => {
        const m = a.value.findIndex((w) => w.id === b.id);
        a.value.splice(m, 1), g.value = !0;
      },
      selectFile: h,
      downloadFile: (b) => {
        e.controller.fileDownload(b);
      }
    };
  },
  render() {
    return c("div", {
      ref: "componentRef",
      style: "width:300px",
      class: this.ns.b()
    }, [c("div", {
      class: this.ns.b("file-list")
    }, [this.fileList.map((e) => c("div", {
      class: this.ns.b("file-item"),
      key: e.id
    }, [c("div", {
      class: this.ns.b("file-item-title"),
      on: {
        click: () => this.downloadFile(e)
      }
    }, [e.name]), c("div", {
      class: this.ns.b("file-item-action")
    }, [c("i-icon", {
      attrs: {
        type: "md-close"
      },
      on: {
        click: () => this.deleteFile(e)
      }
    })])]))]), c("div", {
      on: {
        click: () => this.selectFile()
      },
      class: this.ns.e("button")
    }, [c("i-icon", {
      attrs: {
        type: "md-add"
      }
    }), "添加文件"])]);
  }
});
const Ze = E({
  name: "SyEditGridFileUpload",
  props: _(),
  emits: $(),
  setup(e, {
    emit: t
  }) {
    const s = x("sy-edit-grid-file-upload"), {
      value: o,
      data: i,
      controller: n
    } = B(e), {
      downloadUrl: r,
      uploadUrl: a,
      valueList: d
    } = ie({
      value: o,
      data: i,
      controller: n
    }), h = f(), p = async () => {
      if (!h.value)
        throw new De("容器元素不存在");
      const g = h.value.$el, U = g.offsetHeight, y = ibiz.overlay.createPopover((m) => m(Ye, {
        props: {
          value: d.value,
          uploadUrl: a.value,
          downloadUrl: r.value,
          controller: n.value
        },
        on: {
          close: (w) => {
            y.dismiss(w);
          }
        }
      }), void 0, {
        noArrow: !0,
        placement: "bottom-start",
        offsetOpts: {
          mainAxis: -U,
          crossAxis: 0
        }
      });
      await y.present(g);
      const {
        isModified: C,
        resultFiles: b
      } = await y.onWillDismiss();
      if (C) {
        const m = b.length > 0 ? JSON.stringify(b.map((w) => ({
          name: w.name,
          id: w.id
        }))) : null;
        t("change", m), t("rowSave");
      }
    };
    return Fe(h, "click", (g) => {
      e.disabled || p();
    }), {
      ns: s,
      valueList: d,
      componentRef: h
    };
  },
  render() {
    return c("grid-editor", {
      attrs: {
        disabled: this.disabled,
        readonly: this.readonly
      },
      ref: "componentRef",
      class: this.ns.b()
    }, [c("div", {
      class: this.ns.b("file-list")
    }, [this.valueList.map((e) => c("div", {
      class: this.ns.b("file-item"),
      key: e.id
    }, [c("div", {
      class: this.ns.b("file-item-title")
    }, [e.name])]))])]);
  }
});
E({
  name: "SyInput",
  props: Se(),
  emits: Y(),
  setup(e, {
    emit: t
  }) {
    const s = x("input"), i = e.controller.model, n = f(), r = f(2);
    i.editorType === "TEXTAREA_10" && (r.value = 10);
    const a = D(() => {
      switch (i.editorType) {
        case "TEXTBOX":
          return "text";
        case "PASSWORD":
          return "password";
        case "TEXTAREA":
        case "TEXTAREA_10":
          return "textarea";
        default:
          return "string";
      }
    }), d = f("");
    I(() => e.value, (m, w) => {
      m !== w && (m ? d.value = m : d.value = "");
    }, {
      immediate: !0
    });
    let h = !1, p, g;
    const U = Le((m) => {
      g !== m.target.value && t("change", m.target.value), g = void 0, h = !1, p && p();
    }, 300, {
      leading: !0
    }), y = (m) => {
      h = !0, U(m);
    }, C = (m) => {
      m && m.code === "Enter" && h && (p = () => {
        n.value.$el.dispatchEvent(m);
      });
    }, b = () => {
      g = n.value.currentValue, t("change", g);
    };
    return e.autoFocus && I(n, (m) => {
      m && m.$el.getElementsByTagName("input")[0].focus();
    }), {
      ns: s,
      rows: r,
      type: a,
      currentVal: d,
      handleChange: y,
      handleKeyUp: C,
      handleBlur: b,
      inputRef: n
    };
  },
  render() {
    return c("div", {
      class: [this.ns.b(), this.ns.b("sy-input"), this.ns.is("textarea", Object.is(this.type, "textarea")), this.disabled ? this.ns.m("disabled") : "", this.readonly ? this.ns.m("readonly") : ""]
    }, [this.readonly ? this.currentVal : c("i-input", {
      ref: "inputRef",
      attrs: {
        value: this.currentVal,
        placeholder: this.controller.placeHolder,
        type: this.type,
        rows: this.rows,
        disabled: this.disabled,
        autosize: Object.is(this.type, "textarea")
      },
      on: {
        "on-change": this.handleChange,
        "on-blur": this.handleBlur
      },
      nativeOn: {
        keyup: this.handleKeyUp
      },
      class: this.ns.b("input")
    }, [this.controller.model.unitName && c("i", {
      class: this.ns.e("unit"),
      slot: "suffix"
    }, [this.controller.model.unitName])])]);
  }
});
E({
  name: "SyGridInput",
  props: Ue(),
  emits: $(),
  setup(e, {
    emit: t
  }) {
    const s = x("grid-input"), {
      isInfoMode: o,
      autoFocus: i,
      componentRef: n,
      onOperateChange: r,
      onChange: a
    } = Ee(e, {
      emit: t
    });
    return {
      ns: s,
      isInfoMode: o,
      autoFocus: i,
      componentRef: n,
      onOperateChange: r,
      onChange: a
    };
  },
  render(e) {
    return e("grid-editor", {
      attrs: {
        disabled: this.disabled,
        readonly: this.readonly
      },
      ref: "componentRef",
      class: `${this.ns.b()}`
    }, [e("SyInput", {
      props: {
        ...this.$props,
        readonly: this.isInfoMode,
        disabled: this.disabled,
        autoFocus: this.autoFocus
      },
      on: {
        change: this.onChange,
        operate: this.onOperateChange
      }
    })]);
  }
});
function H(e, t) {
  return c("div", {
    class: e.e("logo")
  }, [t.appIconPath ? c("img", {
    class: e.e("logo-img"),
    attrs: {
      src: t.appIconPath
    }
  }) : null, c("div", {
    class: e.e("logo-caption")
  }, [t.caption])]);
}
const et = E({
  name: "UserAppLayout",
  props: {
    model: {
      type: ue,
      required: !0
    },
    // 视图是否完成加载
    isComplete: {
      type: Boolean,
      default: !1
    },
    // 是否显示分页导航
    isShowTabPageExp: {
      type: Boolean,
      default: !1
    }
  },
  setup(e, {
    emit: t
  }) {
    const s = x("layout"), o = f(!1), i = () => {
      o.value = !o.value, t("onCollapseChange", o.value);
    }, n = D(() => e.model.source.blankMode === !0), r = D(() => !!(window.Environment.manualdownloadurl || ibiz.env.manualdownloadurl));
    return {
      ns: s,
      collapseChange: o,
      isBlank: n,
      collapseMenus: i,
      isShowDownload: r,
      downloadUserBook: () => {
        const d = window.Environment.manualdownloadurl || ibiz.env.manualdownloadurl;
        d ? window.open(d) : console.log("环境变量里没有manualdownloadurl");
      }
    };
  },
  render() {
    return this.isComplete ? c("i-layout", {
      class: [this.ns.b(), this.isBlank ? this.ns.m("blank") : "", this.ns.is("collapse", this.collapseChange), this.ns.is("tab", this.isShowTabPageExp), "user-layout"]
    }, [c("i-sider", {
      attrs: {
        "hide-trigger": !0,
        value: this.collapseChange
      },
      class: [this.ns.b("nav"), this.ns.is("collapse", this.collapseChange)]
    }, [H(this.ns, this.model), this.$slots.menu]), c("i-layout", {
      class: [this.ns.b("content")]
    }, [c("i-header", {
      class: this.ns.b("header")
    }, [c("div", {
      class: this.ns.be("header", "left")
    }, [H(this.ns, this.model), c("div", {
      class: this.ns.be("header", "collapse-icon")
    }, [this.collapseChange ? c("ion-icon", {
      attrs: {
        src: "./assets/img/menu-unfold.svg"
      },
      on: {
        click: () => this.collapseMenus()
      }
    }) : c("ion-icon", {
      attrs: {
        src: "./assets/img/menu-fold.svg"
      },
      on: {
        click: () => this.collapseMenus()
      }
    })]), this.model.source.mainMenuAlign === "TOP" ? c("i-menu", {
      class: this.ns.be("header", "menu"),
      attrs: {
        mode: "horizontal",
        "active-name": "1"
      }
    }) : null]), c("div", {
      class: this.ns.be("header", "right")
    }, [this.isShowDownload && c("div", {
      class: "user-download",
      on: {
        click: () => this.downloadUserBook()
      }
    }, ["用户手册下载"]), c("app-user")])]), c("i-content", {
      class: this.ns.be("content", "main")
    }, [this.$slots.tabPageExp, this.$slots.default])])]) : null;
  }
});
function re(e, t) {
  var n;
  const s = t.firstColName, o = [];
  e.source.columnType === "GROUPGRIDCOLUMN" && e.children.forEach((r) => {
    o.push(re(r, t));
  });
  const i = {
    title: e.title,
    width: e.source.widthUnit === "STAR" ? void 0 : e.width,
    minWidth: e.width,
    align: ((n = e.source.align) == null ? void 0 : n.toLowerCase()) || "center",
    slot: e.codeName,
    key: e.codeName,
    fieldName: e.deFieldName,
    ellipsis: !0,
    tooltip: !1,
    // todo 表格提示用title
    resizable: !0,
    sortable: !t.noSort && e.source.enableSort ? "custom" : !1,
    columnType: e.source.columnType,
    tree: e.codeName === s,
    className: e.codeName === s ? "grid-group-grid-column" : ""
  };
  return o.length > 0 && Object.assign(i, { children: o }), i;
}
function tt(e) {
  const t = e.model, s = [], o = t.columns.map((i) => re(i, e));
  return t.children.forEach((i) => {
    const n = o.find((a) => a.key === i.codeName), r = e.groupField;
    n && i.codeName !== r && s.push(n);
  }), e.singleSelect || s.splice(0, 0, { type: "selection", width: 60 }), s;
}
function st(e) {
  const t = f([]);
  return e.nerve.self.evt.on("created", () => {
    t.value = tt(e);
  }), [D(() => {
    const o = [...t.value];
    if (!o.find((r) => !r.width)) {
      let r = o.length - 1;
      o[r].key === "rowEdit" && (r -= 1), o[r] = {
        ...o[r],
        width: void 0
      };
    }
    const n = o.find((r) => r.columnType === "UAGRIDCOLUMN");
    return n && (n.fixed = "right"), o;
  }), t];
}
function ot(e) {
  const t = (r) => e.items.find((a) => a.srfkey === r.srfkey);
  function s(r) {
    const a = t(r);
    e.singleSelect && e.onSelectionChange([a]), e.onRowClick(a);
  }
  function o(r) {
    e.onDbRowClick(t(r));
  }
  function i(r) {
    if (!e.singleSelect) {
      const a = [];
      r.forEach((d) => {
        const h = t(d);
        h && a.push(h);
      }), e.onSelectionChange(a);
    }
  }
  function n(r) {
    const { column: a, order: d } = r, h = d === "asc" || d === "desc" ? d : void 0;
    e.setSort(a.fieldName, h), e.load();
  }
  return { onRowClick: s, onDbRowClick: o, onSelectionChange: i, onSortChange: n };
}
function it(e) {
  function t(i) {
    !i || i === e.curPage || (e.curPage = i, e.load());
  }
  function s(i) {
    !i || i === e.size || (e.size = i, e.curPage === 1 && e.load());
  }
  function o() {
    e.curPage = 1, e.load();
  }
  return { onPageChange: t, onPageSizeChange: s, onPageReset: o };
}
class nt extends ge {
  constructor() {
    super(...arguments);
    /**
     * 分组数据
     * @return {*}
     * @author: zhujiamin
     * @Date: 2023-10-09 14:00:38
     */
    P(this, "groups", []);
    /**
     * 分组名称属性
     *
     * @author zhanghengfeng
     * @date 2024-12-19 10:12:56
     * @type {string}
     */
    P(this, "groupField", "");
    /**
     * 第一列名称
     *
     * @author zhanghengfeng
     * @date 2024-12-19 10:12:30
     * @type {string}
     */
    P(this, "firstColName", "");
  }
  async onInit() {
    const s = this.model.columns.find(
      (i) => {
        var n;
        return (n = i.source) == null ? void 0 : n.groupItem;
      }
    );
    s && (this.groupField = s.codeName);
    const o = this.model.columns.find((i) => i.codeName !== this.groupField && !i.source.hideDefault && !i.source.hiddenDataItem);
    o && (this.firstColName = o.codeName), await super.onInit();
  }
  /**
   * 部件加载后处理
   *
   * @author lxm
   * @date 2022-08-19 14:08:50
   */
  async afterLoad(s) {
    return await Promise.allSettled(
      Object.values(this.fieldColumns).map(async (o) => {
        await o.loadCodeList();
      })
    ), this.rows = s.map((o) => {
      const i = new J(o, this);
      return this.gridStateNotify(i, be.LOAD), i;
    }), this.handleGroup(s), s;
  }
  /**
   * 处理分组数据
   * @param {ControlVO} items
   * @return {*}
   * @author: zhujiamin
   * @Date: 2023-10-09 14:03:17
   */
  handleGroup(s) {
    const o = /* @__PURE__ */ new Map();
    s.forEach((i) => {
      const n = i[this.groupField];
      o.has(n) || o.set(n, []), o.has(n) && o.get(n).push(i);
    }), this.groups = [], o.forEach((i, n) => {
      this.groups.push({
        caption: `${n}`,
        key: n,
        children: i
      });
    });
  }
}
function rt(e, t, s, o = {}) {
  return ke(e, () => {
    const i = new nt(t, s, o);
    return z(e, "gridRowActiveMode", i.setGridRowActiveMode.bind(i)), i;
  });
}
const at = E({
  props: {
    modelData: he,
    context: {
      type: Object,
      required: !0
    },
    params: {
      type: Object,
      default: () => ({})
    },
    /**
     * 表格行数据默认激活模式
     * - 0 不激活
     * - 1 单击激活
     * - 2 双击激活(默认值)
     *
     * @type {(number | 0 | 1 | 2)}
     */
    gridRowActiveMode: {
      type: Number,
      default: 2
    },
    modal: {
      type: Object
    }
  },
  setup(e) {
    const {
      proxy: t
    } = L(), s = x("grid"), o = rt(t, e.modelData, e.context, e.params), [i] = st(o), {
      onRowClick: n,
      onDbRowClick: r,
      onSelectionChange: a,
      onSortChange: d
    } = ot(o), {
      onPageChange: h,
      onPageReset: p,
      onPageSizeChange: g
    } = it(o), U = (k, S) => {
      const l = t.$refs.grid;
      l && (l.toggleSelect && l.toggleSelect(S), l.highlightCurrentRow && l.highlightCurrentRow(S)), n(k);
    }, y = f(0), C = f(null), b = f(null);
    let m = null, w = 0;
    const T = () => {
      var k;
      if (C.value && ((k = e.modal) == null ? void 0 : k.mode) !== "EMBED")
        if (o.model.source.enablePagingBar && b.value) {
          const S = b.value.$el, l = S.offsetHeight + parseFloat(window.getComputedStyle(S).paddingTop);
          y.value = C.value.offsetHeight - l;
        } else
          y.value = C.value.offsetHeight;
      o.model.source.height > 0 && (y.value = o.model.source.height);
    };
    I(C, (k, S) => {
      k && k !== S && (T(), window.ResizeObserver && C.value && (m = new ResizeObserver((l) => {
        const u = l[0].contentRect.height;
        u !== w && (T(), w = u);
      }), m.observe(C.value)));
    }), we(() => {
      m && m.disconnect();
    });
    const M = D(() => {
      const k = [];
      return o.groups.forEach((S) => {
        if (!S.children.length)
          return;
        const u = [...S.children].shift();
        k.push({
          srfkey: S.caption,
          isGroupData: !0,
          first: u,
          children: S.children,
          _showChildren: !0
        });
      }), k;
    });
    return {
      c: o,
      ns: s,
      columns: i,
      tableData: M,
      onDbRowClick: r,
      onUIRowClick: U,
      onSelectionChange: a,
      onSortChange: d,
      onPageChange: h,
      onPageSizeChange: g,
      onPageReset: p,
      tableHeight: y,
      gridRef: C,
      girdPaginationRef: b
    };
  },
  render() {
    if (!this.c.complete)
      return;
    const e = {};
    return this.c.model.columns.forEach((t) => {
      if (t.source.columnType === "GROUPGRIDCOLUMN")
        return;
      const s = t.codeName;
      e[s] = (o) => {
        const {
          row: i,
          column: n
        } = o;
        if (i.isGroupData && n.key === this.c.firstColName)
          return c("div", {
            class: this.ns.b("sum"),
            attrs: {
              title: i.first[this.c.groupField]
            }
          }, [c("span", [i.first[this.c.groupField]])]);
        const r = this.c.rows.find((a) => a.data.srfkey === i.srfkey);
        if (r)
          return c(this.c.providers[s].component, {
            props: {
              controller: this.c.columns[s],
              row: r
            },
            key: i.srfkey + s
          });
      };
    }), c("control-layout", {
      attrs: {
        modelData: this.c.model
      }
    }, [c("div", {
      ref: "gridRef",
      class: [this.ns.b(), this.ns.b("group-grid"), this.ns.is("show-header", !this.c.model.source.hideHeader), this.ns.is("enable-page", this.c.model.source.enablePagingBar)]
    }, [this.c.groups.length > 0 && c("i-table", {
      ref: "grid",
      attrs: {
        height: this.tableHeight,
        "show-header": !this.c.model.source.hideHeader,
        "highlight-row": !0,
        data: this.tableData,
        columns: this.columns,
        "row-key": "srfkey"
      },
      class: this.ns.b("content"),
      on: {
        "on-row-click": this.onUIRowClick,
        "on-row-dblclick": this.onDbRowClick,
        "on-selection-change": this.onSelectionChange,
        "on-sort-change": this.onSortChange
      },
      scopedSlots: e
    }), this.c.model.source.enablePagingBar && c("app-grid-pagination", {
      ref: "girdPaginationRef",
      attrs: {
        total: this.c.total,
        curPage: this.c.curPage,
        size: this.c.size
      },
      on: {
        change: this.onPageChange,
        "page-size-change": this.onPageSizeChange,
        "page-reset": this.onPageReset
      }
    })])]);
  }
});
class lt {
  constructor() {
    P(this, "component", Me);
  }
}
class ct {
  constructor() {
    P(this, "component", Ge);
  }
  async createController(t, s) {
    const o = new X(t, s);
    return await o.init(), o;
  }
}
class dt {
  constructor() {
    P(this, "component", "IndexView");
  }
}
const ae = E({
  name: "WFStepTraceGrid",
  props: {
    context: Object,
    params: {
      type: Object
    },
    modelPath: {
      type: String,
      required: !0
    },
    modal: {
      type: Object
    },
    deName: {
      type: String,
      required: !0
    }
  },
  setup(e) {
    const {
      proxy: t
    } = L(), s = xe(t, e.modelPath);
    z(t, "deName", s.setDeName.bind(s));
    const o = x("wf-step-trace-grid"), i = f([]), n = (a, d, h = !1) => {
      a.identitylinks.length > 0 || a.comments.length > 0 && a.comments.forEach((p) => {
        h && p.type === "启动流程" || d.push({
          id: V(),
          nodeName: a.userTaskName,
          personName: p.authorName,
          time: p.time,
          content: p.type,
          comment: p.fullMessage
        });
      });
    };
    s.nerve.self.evt.on("mounted", () => {
      var a;
      s.data && ((a = s.data.usertasks) == null || a.forEach((d) => {
        if (d.usertasks && d.usertasks.length > 0) {
          const h = [];
          d.usertasks.forEach((p) => {
            n(p, h, !0);
          }), i.value.push({
            id: V(),
            nodeName: `${d.userTaskName}`,
            personName: "",
            time: "",
            content: "",
            comment: "",
            children: h,
            _showChildren: !0
          });
        } else
          n(d, i.value);
      }), i.value.sort((d, h) => Date.parse(d.time) - Date.parse(h.time)), console.log(1, i.value), console.log(2, s.data));
    });
    const r = f([{
      title: "处理环节",
      key: "nodeName",
      width: 180,
      resizable: !0,
      tree: !0
    }, {
      title: "处理人",
      key: "personName",
      width: 180,
      resizable: !0
    }, {
      title: "处理时间",
      key: "time",
      width: 180,
      resizable: !0
    }, {
      title: "处理内容",
      key: "content",
      width: 180,
      resizable: !0
    }, {
      title: "处理意见",
      key: "comment"
    }]);
    return {
      c: s,
      ns: o,
      gridData: i,
      columns: r
    };
  },
  render() {
    return c("div", {
      class: this.ns.b()
    }, [c("div", {
      class: this.ns.e("title")
    }, ["审批信息"]), c("i-table", {
      attrs: {
        "disabled-hover": !0,
        columns: this.columns,
        data: this.gridData,
        "row-key": "id"
      },
      class: this.ns.e("grid")
    })]);
  }
});
class ut extends ve {
  async calcWfToolbar() {
    await super.calcWfToolbar(), this.isEditable && this.wfLinks.unshift({
      sequenceFlowName: "保存",
      type: "FORM_SAVE"
    });
  }
  async onLinkClick(t) {
    t.type === "FORM_SAVE" ? await this.save() : super.onLinkClick(t);
  }
}
E({
  props: {
    context: Object,
    params: {
      type: Object
    },
    modelPath: {
      type: String,
      required: !0
    },
    modal: {
      type: Object
    }
  },
  setup(e) {
    const {
      proxy: t
    } = L(), s = K(t, (r, a) => new ut(e.modelPath, r, a)), o = x(`view-${me.DE_WF_DYNA_EDIT_VIEW3}`.toLowerCase()), i = f(["mainForm"]);
    return {
      c: s,
      ns: o,
      onTabClick: (r) => {
        i.value.includes(r) || i.value.push(r);
      },
      lazyList: i
    };
  },
  render(e) {
    const t = [];
    if (this.c.complete) {
      const {
        activeForm: s
      } = this.c;
      s && this.c.providers[s.name] && t.push(e(this.c.providers[s.name].component, {
        props: {
          modelData: s,
          context: this.c.context,
          params: this.c.params
        },
        style: {
          height: "auto"
        },
        on: {
          neuronInit: this.c.nerve.onNeuronInit("form")
        }
      }));
    }
    if (this.c.complete && this.c.model.drTab.pages[0]) {
      const s = this.c.model.drTab.pages[0], o = this.c.drPages[s.source.name];
      t.push(e(ae, {
        attrs: {
          context: o.context,
          params: o.params,
          deName: this.c.model.appEntity.source.codeName,
          modal: this.modal,
          modelPath: s.embedView.source.modelPath
        }
      }));
    }
    return e("view-base", {
      attrs: {
        controller: this.c
      },
      scopedSlots: {
        toolbar: () => this.c.complete ? [this.c.wfLinks.length > 0 && e("wf-toolbar", {
          attrs: {
            wfLinks: this.c.wfLinks
          },
          on: {
            "wf-link-click": (s) => {
              this.c.onLinkClick(s);
            }
          }
        })] : null
      }
    }, [this.c.complete && e("i-tabs", {
      class: [this.ns.be("", "tab")],
      attrs: {
        name: this.c.model.drTab.source.name
      },
      on: {
        "on-click": this.onTabClick
      }
    }, [e("i-tab-pane", {
      class: this.ns.be("", "tab-item"),
      attrs: {
        tab: this.c.model.drTab.source.name,
        label: this.c.model.drTab.source.editItemCaption,
        name: "mainForm"
      }
    }, [t]), this.c.model.drTab.pages.map((s) => {
      const o = this.c.drPages[s.source.name];
      return e("i-tab-pane", {
        class: this.ns.be("", "tab-item"),
        attrs: {
          tab: this.c.model.drTab.source.name,
          disabled: this.c.isNewData,
          label: s.source.caption,
          name: s.source.name
        }
      }, [!this.c.isNewData && this.lazyList.includes(s.source.name) && e("ViewShell", {
        attrs: {
          context: o.context,
          params: o.params,
          modal: {
            mode: ee.EMBED
          },
          modelPath: s.embedView.source.modelPath,
          // 流程跟踪视图用
          deName: this.c.model.appEntity.source.codeName
        },
        on: {
          neuronInit: this.c.nerve.onNeuronInit(s.source.name)
        },
        key: o.key
      })]);
    })])]);
  }
});
E({
  name: "SyEditView3",
  props: {
    context: Object,
    params: {
      type: Object
    },
    modelPath: {
      type: String,
      required: !0
    },
    modal: {
      type: Object
    }
  },
  setup(e) {
    const {
      proxy: t
    } = L(), s = Pe(t, e.modelPath), o = x("view-deeditview3"), i = f(["mainForm"]);
    return {
      c: s,
      ns: o,
      onTabClick: (r) => {
        i.value.includes(r) || i.value.push(r);
      },
      lazyList: i
    };
  },
  render(e) {
    return e("view-base", {
      attrs: {
        controller: this.c
      }
    }, [this.c.complete && e("i-tabs", {
      class: [this.ns.be("", "tab")],
      attrs: {
        name: this.c.model.drTab.source.name
      },
      on: {
        "on-click": this.onTabClick
      }
    }, [e("i-tab-pane", {
      class: this.ns.be("", "tab-item"),
      attrs: {
        tab: this.c.model.drTab.source.name,
        label: this.c.model.drTab.source.editItemCaption,
        name: "mainForm"
      }
    }, [e("edit-form-control", {
      attrs: {
        modelData: this.c.model.form,
        context: this.c.context,
        params: this.c.params
      },
      style: {
        height: "auto"
      },
      on: {
        neuronInit: this.c.nerve.onNeuronInit(this.c.model.form.source.name)
      }
    }), e(ae, {
      attrs: {
        context: this.c.drPages[this.c.model.drTab.pages[0].source.name].context,
        params: this.c.drPages[this.c.model.drTab.pages[0].source.name].params,
        deName: this.c.model.appEntity.source.codeName,
        modal: this.modal,
        modelPath: this.c.model.drTab.pages[0].embedView.source.modelPath
      }
    })]), this.c.model.drTab.pages.map((t) => {
      const s = this.c.drPages[t.source.name];
      if (s)
        return e("i-tab-pane", {
          class: this.ns.be("", "tab-item"),
          attrs: {
            tab: this.c.model.drTab.source.name,
            disabled: this.c.isNewData,
            label: t.source.caption,
            name: t.source.name
          }
        }, [!this.c.isNewData && this.lazyList.includes(t.source.name) && e("ViewShell", {
          attrs: {
            context: s.context,
            params: s.params,
            modal: {
              mode: ee.EMBED
            },
            modelPath: t.embedView.source.modelPath,
            // 流程跟踪视图用
            deName: this.c.model.appEntity.source.codeName
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit(t.source.name)
          },
          key: s.key
        })]);
    })])]);
  }
});
class ht {
  constructor() {
    P(this, "formEditor", "SyFileUpload");
    P(this, "gridEditor", "SyGridFileUploadContainer");
  }
  async createController(t, s) {
    const o = new Q(t, s);
    return await o.init(), o;
  }
}
class mt extends te {
  async execAction(t, s, o, i, n) {
    if (o && o.length > 0) {
      const a = (await ibiz.entityService.getService("XQFBXQPS", s)).local.getList(s);
      o.forEach((d) => {
        const h = a.find((p) => p.srfkey === d.srfkey);
        h && (h.psjg = "10", d.psjg = "10");
      });
    }
    return {
      refresh: !1,
      closeView: !1
    };
  }
}
class pt {
  constructor() {
    P(this, "handler");
  }
  async getHandler() {
    return this.handler || (this.handler = new mt()), this.handler;
  }
}
class ft extends te {
  async execAction(t, s, o, i, n) {
    if (o && o.length > 0) {
      const a = (await ibiz.entityService.getService("XQFBXQPS", s)).local.getList(s);
      o.forEach((d) => {
        const h = a.find((p) => p.srfkey === d.srfkey);
        h && (h.psjg = "20", d.psjg = "20");
      });
    }
    return {
      refresh: !1,
      closeView: !1
    };
  }
}
class gt {
  constructor() {
    P(this, "handler");
  }
  async getHandler() {
    return this.handler || (this.handler = new ft()), this.handler;
  }
}
class bt {
  constructor() {
    P(this, "component", "GroupGrid");
  }
}
const vt = new Ae(import.meta.url), It = {
  mateUrl: import.meta.url,
  install(e) {
    pe.getModelService().then((t) => {
      var o;
      ((o = t.app.userParams) == null ? void 0 : o.autoWidth) === "true" && document.getElementsByClassName("app")[0].classList.add("auto-width");
    }), vt.loadStyle(["/style.css"]), ibiz.config.enableDataInfoBar = !1, ibiz.config.gridEditShowMode = "all", e.component("WfToolbar", Be), ibiz.register.view.register(
      "VIEW_CUSTOM_SyWebIndexView",
      new dt()
    ), ibiz.register.view.register(
      "VIEW_CUSTOM_PresetWFChartView",
      new lt()
    ), ibiz.register.gridColumn.register(
      "GRID_COLRENDER_CodeListGridColumn",
      new ct()
    ), e.component("SyFileUpload", Je), e.component("SyGridFileUpload", Qe), e.component("SyEditGridFileUpload", Ze), e.component("SyGridFileUploadContainer", Ke), ibiz.register.editor.register(
      "EDITOR_CUSTOMSTYLE_SyFileUpload",
      new ht()
    ), e.component("AppLayout", et), ibiz.register.uiAction.register(
      "DEUIACTION_BatchApprovalOrdersId",
      new pt()
    ), ibiz.register.uiAction.register(
      "DEUIACTION_BatchNoApprovalOrdersId",
      new gt()
    ), e.component("GroupGrid", at), ibiz.register.control.register(
      "GRID_RENDER_GROUP_GRID",
      new bt()
    );
  }
};
export {
  It as default
};
